/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.response;

import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseHeaders;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseStatus;
import com.hubspot.horizon.shaded.com.ning.http.client.ResponseBase;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.Cookie;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.CookieDecoder;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.response.NettyResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.util.ChannelBufferUtils;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBufferInputStream;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NettyResponse
extends ResponseBase {
    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return ChannelBufferUtils.channelBuffer2bytes(this.getResponseBodyAsChannelBuffer());
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return this.getResponseBodyAsChannelBuffer().toByteBuffer();
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return this.getResponseBodyAsChannelBuffer().toString(this.calculateCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return new ChannelBufferInputStream(this.getResponseBodyAsChannelBuffer());
    }

    public ChannelBuffer getResponseBodyAsChannelBuffer() throws IOException {
        ChannelBuffer b = null;
        switch (this.bodyParts.size()) {
            case 0: {
                b = ChannelBuffers.EMPTY_BUFFER;
                break;
            }
            case 1: {
                b = ((NettyResponseBodyPart)NettyResponseBodyPart.class.cast(this.bodyParts.get(0))).getChannelBuffer();
                break;
            }
            default: {
                ChannelBuffer[] channelBuffers = new ChannelBuffer[this.bodyParts.size()];
                for (int i = 0; i < this.bodyParts.size(); ++i) {
                    channelBuffers[i] = ((NettyResponseBodyPart)NettyResponseBodyPart.class.cast(this.bodyParts.get(i))).getChannelBuffer();
                }
                b = ChannelBuffers.wrappedBuffer(channelBuffers);
            }
        }
        return b;
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String response = this.getResponseBody(charset);
        return response.length() <= maxLength ? response : response.substring(0, maxLength);
    }

    @Override
    protected List<Cookie> buildCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
            if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            List<String> v = header.getValue();
            for (String value : v) {
                cookies.add(CookieDecoder.decode(value));
            }
        }
        return cookies;
    }
}

