/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.response;

import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.util.ChannelBufferUtils;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpChunk;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NettyResponseBodyPart
extends HttpResponseBodyPart {
    private final ChannelBuffer content;
    private volatile byte[] bytes;
    private final int length;

    public NettyResponseBodyPart(HttpResponse response, boolean last) {
        this(response, null, last);
    }

    public NettyResponseBodyPart(HttpResponse response, HttpChunk chunk, boolean last) {
        super(last);
        this.content = chunk != null ? chunk.getContent() : response.getContent();
        this.length = this.content.readableBytes();
    }

    @Override
    public byte[] getBodyPartBytes() {
        if (this.bytes == null) {
            this.bytes = ChannelBufferUtils.channelBuffer2bytes(this.content);
        }
        return this.bytes;
    }

    @Override
    public int writeTo(OutputStream outputStream) throws IOException {
        ChannelBuffer b = this.getChannelBuffer();
        int read = b.readableBytes();
        int index = b.readerIndex();
        if (read > 0) {
            b.readBytes(outputStream, read);
        }
        b.readerIndex(index);
        return read;
    }

    public ChannelBuffer getChannelBuffer() {
        return this.content;
    }

    @Override
    public ByteBuffer getBodyByteBuffer() {
        return this.content.toByteBuffer();
    }

    @Override
    public int length() {
        return this.length;
    }
}

