/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.spring;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class GreenMailBean
implements InitializingBean,
DisposableBean,
BeanNameAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private GreenMail greenMail;
    private boolean autostart = true;
    private boolean smtpProtocol = true;
    private boolean smtpsProtocol = false;
    private boolean pop3Protocol = true;
    private boolean pop3sProtocol = false;
    private boolean imapProtocol = false;
    private boolean imapsProtocol = false;
    private List<String> users;
    private int portOffset = 3000;
    private String hostname;
    private boolean started;
    private ServerSetup smtpServerSetup;
    private ServerSetup smtpsServerSetup;
    private long serverStartupTimeout = 1000L;

    public void afterPropertiesSet() throws Exception {
        this.greenMail = new GreenMail(this.createServerSetup());
        if (null != this.users) {
            for (String user : this.users) {
                int posColon = user.indexOf(58);
                int posAt = user.indexOf(64);
                String login = user.substring(0, posColon);
                String pwd = user.substring(posColon + 1, posAt);
                String domain = user.substring(posAt + 1);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding user " + login + ':' + pwd + '@' + domain);
                }
                this.greenMail.setUser(login + '@' + domain, login, pwd);
            }
        }
        if (this.autostart) {
            this.greenMail.start();
            this.started = true;
        }
    }

    private ServerSetup[] createServerSetup() {
        ArrayList<ServerSetup> setups = new ArrayList<ServerSetup>();
        if (this.smtpProtocol) {
            this.smtpServerSetup = this.createTestServerSetup(ServerSetup.SMTP);
            setups.add(this.smtpServerSetup);
        }
        if (this.smtpsProtocol) {
            this.smtpsServerSetup = this.createTestServerSetup(ServerSetup.SMTPS);
            setups.add(this.smtpsServerSetup);
        }
        if (this.pop3Protocol) {
            setups.add(this.createTestServerSetup(ServerSetup.POP3));
        }
        if (this.pop3sProtocol) {
            setups.add(this.createTestServerSetup(ServerSetup.POP3S));
        }
        if (this.imapProtocol) {
            setups.add(this.createTestServerSetup(ServerSetup.IMAP));
        }
        if (this.imapsProtocol) {
            setups.add(this.createTestServerSetup(ServerSetup.IMAPS));
        }
        return setups.toArray(new ServerSetup[setups.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        GreenMail greenMail = this.greenMail;
        synchronized (greenMail) {
            if (this.started) {
                this.log.warn("Can not start server (already started)");
            } else {
                this.greenMail.start();
                this.started = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        GreenMail greenMail = this.greenMail;
        synchronized (greenMail) {
            if (this.started) {
                this.greenMail.stop();
                this.started = true;
            } else {
                this.log.warn("Can not stop server (not started).");
            }
        }
    }

    private ServerSetup createTestServerSetup(ServerSetup theSetup) {
        ServerSetup serverSetup = new ServerSetup(this.portOffset + theSetup.getPort(), this.hostname, theSetup.getProtocol());
        serverSetup.setServerStartupTimeout(this.serverStartupTimeout);
        return serverSetup;
    }

    public MimeMessage[] getReceivedMessages() {
        return this.greenMail.getReceivedMessages();
    }

    public void destroy() throws Exception {
        this.greenMail.stop();
    }

    public void setAutostart(boolean theAutostart) {
        this.autostart = theAutostart;
    }

    public boolean isAutostart() {
        return this.autostart;
    }

    public void setSmtpProtocol(boolean theSmtpProtocoll) {
        this.smtpProtocol = theSmtpProtocoll;
    }

    public boolean isSmtpProtocol() {
        return this.smtpProtocol;
    }

    public void setSmtpsProtocol(boolean theSmtpsProtocoll) {
        this.smtpsProtocol = theSmtpsProtocoll;
    }

    public boolean isSmtpsProtocol() {
        return this.smtpsProtocol;
    }

    public void setPop3Protocol(boolean thePop3Protocoll) {
        this.pop3Protocol = thePop3Protocoll;
    }

    public boolean isPop3Protocol() {
        return this.pop3Protocol;
    }

    public void setPop3sProtocol(boolean thePop3sProtocoll) {
        this.pop3sProtocol = thePop3sProtocoll;
    }

    public boolean isPop3sProtocol() {
        return this.pop3sProtocol;
    }

    public void setImapProtocol(boolean theImapProtocoll) {
        this.imapProtocol = theImapProtocoll;
    }

    public boolean isImapProtocol() {
        return this.imapProtocol;
    }

    public void setImapsProtocol(boolean theImapsProtocoll) {
        this.imapsProtocol = theImapsProtocoll;
    }

    public boolean isImapsProtocol() {
        return this.imapsProtocol;
    }

    public void setHostname(String pHostname) {
        this.hostname = pHostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setPortOffset(int pPortOffset) {
        this.portOffset = pPortOffset;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setUsers(List<String> theUsers) {
        this.users = theUsers;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public boolean isStarted() {
        return this.started;
    }

    public GreenMail getGreenMail() {
        return this.greenMail;
    }

    public void sendEmail(String theTo, String theFrom, String theSubject, String theContent) {
        if (null == this.smtpServerSetup) {
            throw new IllegalStateException("Can not send mail, no SMTP or SMTPS setup found");
        }
        GreenMailUtil.sendTextEmail((String)theTo, (String)theFrom, (String)theSubject, (String)theContent, (ServerSetup)this.smtpServerSetup);
    }

    public void setBeanName(String pName) {
        this.name = pName;
    }

    public long getServerStartupTimeout() {
        return this.serverStartupTimeout;
    }

    public void setServerStartupTimeout(long serverStartupTimeout) {
        this.serverStartupTimeout = serverStartupTimeout;
    }
}

