/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.parser.ExtRenderListener;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineDashPattern;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Path;
import com.itextpdf.text.pdf.parser.PathConstructionRenderInfo;
import com.itextpdf.text.pdf.parser.PathPaintingRenderInfo;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContext;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRegionFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCleanUpRenderListener
implements ExtRenderListener {
    private static final Color CLEANED_AREA_FILL_COLOR = Color.WHITE;
    private PdfStamper pdfStamper;
    private PdfCleanUpRegionFilter filter;
    private List<PdfCleanUpContentChunk> chunks = new ArrayList<PdfCleanUpContentChunk>();
    private Stack<PdfCleanUpContext> contextStack = new Stack();
    private int strNumber = 1;
    private Path unfilteredCurrentPath = new Path();
    private Path currentStrokePath = new Path();
    private Path currentFillPath = new Path();
    private Path newClippingPath;
    private boolean clipPath;
    private int clippingRule;

    public PdfCleanUpRenderListener(PdfStamper pdfStamper, PdfCleanUpRegionFilter filter) {
        this.pdfStamper = pdfStamper;
        this.filter = filter;
        this.initClippingPath();
    }

    public void renderText(TextRenderInfo renderInfo) {
        if (renderInfo.getPdfString().toUnicodeString().length() == 0) {
            return;
        }
        if (this.newClippingPath.isEmpty()) {
            LineSegment baseline = renderInfo.getUnscaledBaseline();
            this.chunks.add(new PdfCleanUpContentChunk.Text(renderInfo.getPdfString(), baseline.getStartPoint(), baseline.getEndPoint(), false, this.strNumber));
        } else {
            for (TextRenderInfo ri : renderInfo.getCharacterRenderInfos()) {
                boolean isAllowed = this.filter.allowText(ri);
                LineSegment baseline = ri.getUnscaledBaseline();
                this.chunks.add(new PdfCleanUpContentChunk.Text(ri.getPdfString(), baseline.getStartPoint(), baseline.getEndPoint(), isAllowed, this.strNumber));
            }
        }
        ++this.strNumber;
    }

    public void renderImage(ImageRenderInfo renderInfo) {
        List<Rectangle> areasToBeCleaned = this.getImageAreasToBeCleaned(renderInfo);
        if (areasToBeCleaned == null || this.newClippingPath.isEmpty()) {
            this.chunks.add(new PdfCleanUpContentChunk.Image(false, null));
        } else {
            try {
                PdfImageObject pdfImage = renderInfo.getImage();
                byte[] imageBytes = this.processImage(pdfImage.getImageAsBytes(), areasToBeCleaned);
                if (renderInfo.getRef() == null && pdfImage != null) {
                    PdfDictionary dict = pdfImage.getDictionary();
                    PdfObject imageMask = dict.get(PdfName.IMAGEMASK);
                    Image image = Image.getInstance((byte[])imageBytes);
                    if (imageMask == null) {
                        imageMask = dict.get(PdfName.IM);
                    }
                    if (imageMask != null && imageMask.equals(PdfBoolean.PDFTRUE)) {
                        image.makeMask();
                    }
                    PdfContentByte canvas = this.getContext().getCanvas();
                    canvas.addImage(image, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, true);
                } else if (pdfImage != null && imageBytes != pdfImage.getImageAsBytes()) {
                    this.chunks.add(new PdfCleanUpContentChunk.Image(true, imageBytes));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void beginTextBlock() {
    }

    public void endTextBlock() {
    }

    public void modifyPath(PathConstructionRenderInfo renderInfo) {
        if (this.newClippingPath.isEmpty()) {
            return;
        }
        List segmentData = renderInfo.getSegmentData();
        switch (renderInfo.getOperation()) {
            case 1: {
                this.unfilteredCurrentPath.moveTo(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue());
                break;
            }
            case 2: {
                this.unfilteredCurrentPath.lineTo(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue());
                break;
            }
            case 3: {
                this.unfilteredCurrentPath.curveTo(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue(), ((Float)segmentData.get(2)).floatValue(), ((Float)segmentData.get(3)).floatValue(), ((Float)segmentData.get(4)).floatValue(), ((Float)segmentData.get(5)).floatValue());
                break;
            }
            case 4: {
                this.unfilteredCurrentPath.curveTo(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue(), ((Float)segmentData.get(2)).floatValue(), ((Float)segmentData.get(3)).floatValue());
                break;
            }
            case 5: {
                this.unfilteredCurrentPath.curveFromTo(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue(), ((Float)segmentData.get(2)).floatValue(), ((Float)segmentData.get(3)).floatValue());
                break;
            }
            case 6: {
                this.unfilteredCurrentPath.closeSubpath();
                break;
            }
            case 7: {
                this.unfilteredCurrentPath.rectangle(((Float)segmentData.get(0)).floatValue(), ((Float)segmentData.get(1)).floatValue(), ((Float)segmentData.get(2)).floatValue(), ((Float)segmentData.get(3)).floatValue());
            }
        }
    }

    public Path renderPath(PathPaintingRenderInfo renderInfo) {
        if (this.newClippingPath.isEmpty()) {
            this.currentFillPath = this.currentStrokePath = new Path();
            return this.newClippingPath;
        }
        boolean stroke = (renderInfo.getOperation() & 1) != 0;
        boolean fill = (renderInfo.getOperation() & 2) != 0;
        float lineWidth = renderInfo.getLineWidth();
        int lineCapStyle = renderInfo.getLineCapStyle();
        int lineJoinStyle = renderInfo.getLineJoinStyle();
        float miterLimit = renderInfo.getMiterLimit();
        LineDashPattern lineDashPattern = renderInfo.getLineDashPattern();
        if (stroke) {
            this.currentStrokePath = this.filterCurrentPath(renderInfo.getCtm(), true, -1, lineWidth, lineCapStyle, lineJoinStyle, miterLimit, lineDashPattern);
        }
        if (fill) {
            this.currentFillPath = this.filterCurrentPath(renderInfo.getCtm(), false, renderInfo.getRule(), lineWidth, lineCapStyle, lineJoinStyle, miterLimit, lineDashPattern);
        }
        if (this.clipPath) {
            this.newClippingPath = fill && renderInfo.getRule() == this.clippingRule ? this.currentFillPath : this.filterCurrentPath(renderInfo.getCtm(), false, this.clippingRule, lineWidth, lineCapStyle, lineJoinStyle, miterLimit, lineDashPattern);
        }
        this.unfilteredCurrentPath = new Path();
        return this.newClippingPath;
    }

    public void clipPath(int rule) {
        this.clipPath = true;
        this.clippingRule = rule;
    }

    public boolean isClipped() {
        return this.clipPath;
    }

    public void setClipped(boolean clipPath) {
        this.clipPath = clipPath;
    }

    public int getClippingRule() {
        return this.clippingRule;
    }

    public Path getCurrentStrokePath() {
        return this.currentStrokePath;
    }

    public Path getCurrentFillPath() {
        return this.currentFillPath;
    }

    public Path getNewClipPath() {
        return this.newClippingPath;
    }

    public List<PdfCleanUpContentChunk> getChunks() {
        return this.chunks;
    }

    public PdfCleanUpContext getContext() {
        return this.contextStack.peek();
    }

    public void registerNewContext(PdfDictionary resources, PdfContentByte canvas) {
        canvas = canvas == null ? new PdfContentByte(this.pdfStamper.getWriter()) : canvas;
        this.contextStack.push(new PdfCleanUpContext(resources, canvas));
    }

    public void popContext() {
        this.contextStack.pop();
    }

    public void clearChunks() {
        this.chunks.clear();
        this.strNumber = 1;
    }

    private void initClippingPath() {
        this.newClippingPath = new Path();
        this.newClippingPath.moveTo(30.0f, 30.0f);
        this.newClippingPath.lineTo(30.0f, 40.0f);
    }

    private List<Rectangle> getImageAreasToBeCleaned(ImageRenderInfo renderInfo) {
        return this.filter.getCoveredAreas(renderInfo);
    }

    private byte[] processImage(byte[] imageBytes, List<Rectangle> areasToBeCleaned) {
        if (areasToBeCleaned.isEmpty()) {
            return imageBytes;
        }
        try {
            BufferedImage image = Imaging.getBufferedImage((byte[])imageBytes);
            ImageInfo imageInfo = Imaging.getImageInfo((byte[])imageBytes);
            this.cleanImage(image, areasToBeCleaned);
            if (imageInfo.getFormat() == ImageFormats.JPEG) {
                return this.getJPGBytes(image);
            }
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            if (imageInfo.getFormat() == ImageFormats.TIFF) {
                params.put("COMPRESSION", 5);
            }
            return Imaging.writeImageToBytes((BufferedImage)image, (ImageFormat)imageInfo.getFormat(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanImage(BufferedImage image, List<Rectangle> areasToBeCleaned) {
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(CLEANED_AREA_FILL_COLOR);
        for (Rectangle rect : areasToBeCleaned) {
            int scaledBottomY = (int)Math.ceil(rect.getBottom() * (float)image.getHeight());
            int scaledTopY = (int)Math.floor(rect.getTop() * (float)image.getHeight());
            int x = (int)Math.ceil(rect.getLeft() * (float)image.getWidth());
            int y = scaledTopY * -1 + image.getHeight();
            int width = (int)Math.floor(rect.getRight() * (float)image.getWidth()) - x;
            int height = scaledTopY - scaledBottomY;
            graphics.fillRect(x, y, width, height);
        }
        graphics.dispose();
    }

    private byte[] getJPGBytes(BufferedImage image) {
        ByteArrayOutputStream outputStream = null;
        try {
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(1.0f);
            outputStream = new ByteArrayOutputStream();
            jpgWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
            IIOImage outputImage = new IIOImage(image, null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            this.closeOutputStream(outputStream);
            return byArray;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeOutputStream(outputStream);
                throw throwable;
            }
        }
    }

    private Path filterCurrentPath(Matrix ctm, boolean stroke, int fillingRule, float lineWidth, int lineCapStyle, int lineJoinStyle, float miterLimit, LineDashPattern lineDashPattern) {
        Path path = new Path(this.unfilteredCurrentPath.getSubpaths());
        if (stroke) {
            return this.filter.filterStrokePath(path, ctm, lineWidth, lineCapStyle, lineJoinStyle, miterLimit, lineDashPattern);
        }
        return this.filter.filterFillPath(path, ctm, fillingRule);
    }

    private void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

