/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.ModelBuilderPlugin;
import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.IncrementsPluginTools;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.IIncrementsPluginHook;
import com.itfsw.mybatis.generator.plugins.utils.hook.IModelBuilderPluginHook;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class IncrementsPlugin
extends BasePlugin
implements IModelBuilderPluginHook,
IIncrementsPluginHook {
    public static final String PRO_INCREMENTS_COLUMNS = "incrementsColumns";
    public static final String FIELD_INC_MAP = "incrementsColumnsInfoMap";
    public static final String METHOD_INC_CHECK = "hasIncsForColumn";
    private IncrementsPluginTools incTools;

    @Override
    public boolean validate(List<String> warnings) {
        if (!PluginTools.checkDependencyPlugin(this.getContext(), ModelBuilderPlugin.class)) {
            warnings.add("itfsw:\u63d2\u4ef6" + this.getClass().getTypeName() + "\u63d2\u4ef6\u9700\u914d\u5408com.itfsw.mybatis.generator.plugins.ModelBuilderPlugin\u63d2\u4ef6\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.incTools = IncrementsPluginTools.getTools(this.context, introspectedTable, this.warnings);
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleSelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeySelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    @Override
    public boolean modelBuilderClassGenerated(TopLevelClass topLevelClass, InnerClass builderClass, List<IntrospectedColumn> columns, IntrospectedTable introspectedTable) {
        if (this.incTools.support()) {
            InnerEnum eIncrements = new InnerEnum(new FullyQualifiedJavaType("Inc"));
            eIncrements.setVisibility(JavaVisibility.PUBLIC);
            eIncrements.setStatic(true);
            eIncrements.addEnumConstant("INC(\"+\")");
            eIncrements.addEnumConstant("DEC(\"-\")");
            this.commentGenerator.addEnumComment(eIncrements, introspectedTable);
            Field fValue = new Field("value", FullyQualifiedJavaType.getStringInstance());
            fValue.setVisibility(JavaVisibility.PRIVATE);
            fValue.setFinal(true);
            this.commentGenerator.addFieldComment(fValue, introspectedTable);
            eIncrements.addField(fValue);
            Method mInc = new Method("Inc");
            mInc.setConstructor(true);
            mInc.addBodyLine("this.value = value;");
            mInc.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "value"));
            this.commentGenerator.addGeneralMethodComment(mInc, introspectedTable);
            FormatTools.addMethodWithBestPosition(eIncrements, mInc);
            Method mValue = JavaElementGeneratorTools.generateGetterMethod(fValue);
            this.commentGenerator.addGeneralMethodComment(mValue, introspectedTable);
            FormatTools.addMethodWithBestPosition(eIncrements, mValue);
            builderClass.addInnerEnum(eIncrements);
            Field fIncrements = JavaElementGeneratorTools.generateField(FIELD_INC_MAP, JavaVisibility.PROTECTED, new FullyQualifiedJavaType("Map<String, " + this.incTools.getIncEnum().getFullyQualifiedName() + ">"), "new HashMap<String, " + this.incTools.getIncEnum().getFullyQualifiedName() + ">()");
            this.commentGenerator.addFieldComment(fIncrements, introspectedTable);
            topLevelClass.addField(fIncrements);
            topLevelClass.addImportedType("java.util.Map");
            topLevelClass.addImportedType("java.util.HashMap");
            Method mGetter = JavaElementGeneratorTools.generateGetterMethod(fIncrements);
            this.commentGenerator.addGetterComment(mGetter, introspectedTable, null);
            FormatTools.addMethodWithBestPosition(topLevelClass, mGetter);
            Method mSetter = JavaElementGeneratorTools.generateSetterMethod(fIncrements);
            this.commentGenerator.addSetterComment(mSetter, introspectedTable, null);
            FormatTools.addMethodWithBestPosition(topLevelClass, mSetter);
            Method mHasIncsForColumn = JavaElementGeneratorTools.generateMethod(METHOD_INC_CHECK, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getBooleanPrimitiveInstance(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
            this.commentGenerator.addGeneralMethodComment(mHasIncsForColumn, introspectedTable);
            mHasIncsForColumn.addBodyLine("return incrementsColumnsInfoMap.get(column) != null;");
            FormatTools.addMethodWithBestPosition(topLevelClass, mHasIncsForColumn);
            for (IntrospectedColumn column : columns) {
                if (!this.incTools.supportColumn(column)) continue;
                Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)column, (Context)this.context, (IntrospectedTable)introspectedTable);
                Method mIncrements = JavaElementGeneratorTools.generateMethod(field.getName(), JavaVisibility.PUBLIC, builderClass.getType(), new Parameter(field.getType(), field.getName()), new Parameter(this.incTools.getIncEnum(), "inc"));
                this.commentGenerator.addSetterComment(mIncrements, introspectedTable, column);
                Method setterMethod = JavaBeansUtil.getJavaBeansSetter((IntrospectedColumn)column, (Context)this.context, (IntrospectedTable)introspectedTable);
                mIncrements.addBodyLine("obj.incrementsColumnsInfoMap.put(\"" + column.getActualColumnName() + "\", inc);");
                mIncrements.addBodyLine("obj." + setterMethod.getName() + "(" + field.getName() + ");");
                mIncrements.addBodyLine("return this;");
                FormatTools.addMethodWithBestPosition(builderClass, mIncrements);
            }
        }
        return true;
    }

    @Override
    public boolean modelBuilderSetterMethodGenerated(Method method, TopLevelClass topLevelClass, InnerClass builderClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        return true;
    }

    @Override
    public List<Element> incrementSetElementGenerated(IntrospectedColumn introspectedColumn, String prefix, boolean hasComma) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (this.incTools.supportColumn(introspectedColumn)) {
            list.add((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = "));
            XmlElement choose = new XmlElement("choose");
            XmlElement when = new XmlElement("when");
            when.addAttribute(new Attribute("test", (prefix != null ? prefix : "_parameter.") + METHOD_INC_CHECK + "('" + MyBatis3FormattingUtilities.escapeStringForMyBatis3((String)introspectedColumn.getActualColumnName()) + "')"));
            TextElement spec = new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " ${" + (prefix != null ? prefix : "") + FIELD_INC_MAP + "." + MyBatis3FormattingUtilities.escapeStringForMyBatis3((String)introspectedColumn.getActualColumnName()) + ".value} " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
            when.addElement((Element)spec);
            choose.addElement((Element)when);
            XmlElement otherwise = new XmlElement("otherwise");
            TextElement normal = new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
            otherwise.addElement((Element)normal);
            choose.addElement((Element)otherwise);
            list.add((Element)choose);
            if (hasComma) {
                list.add((Element)new TextElement(","));
            }
        }
        return list;
    }

    @Override
    public Element incrementSetsWithSelectiveEnhancedPluginElementGenerated(IntrospectedColumn versionColumn) {
        if (this.incTools.support()) {
            XmlElement choose = new XmlElement("choose");
            for (IntrospectedColumn introspectedColumn : this.incTools.getColumns()) {
                if (versionColumn != null && introspectedColumn.getActualColumnName().equals(versionColumn.getActualColumnName())) continue;
                XmlElement when = new XmlElement("when");
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(introspectedColumn.getActualColumnName());
                sb.append("'.toString()");
                sb.append(" == ");
                sb.append("column.value");
                when.addAttribute(new Attribute("test", sb.toString()));
                when.addElement((Element)new TextElement("${column.escapedColumnName} = ${column.escapedColumnName} ${record.incrementsColumnsInfoMap." + introspectedColumn.getActualColumnName() + ".value} #{record.${column.javaProperty},jdbcType=${column.jdbcType}}"));
                choose.addElement((Element)when);
            }
            if (versionColumn == null) {
                XmlElement otherwise = new XmlElement("otherwise");
                otherwise.addElement((Element)new TextElement("${column.escapedColumnName} = #{record.${column.javaProperty},jdbcType=${column.jdbcType}}"));
                choose.addElement((Element)otherwise);
            } else {
                XmlElement when = new XmlElement("when");
                when.addAttribute(new Attribute("test", "column.value != '" + versionColumn.getActualColumnName() + "'.toString()"));
                when.addElement((Element)new TextElement("${column.escapedColumnName} = #{record.${column.javaProperty},jdbcType=${column.jdbcType}}"));
                choose.addElement((Element)when);
            }
            return choose;
        }
        return null;
    }

    private void generatedWithSelective(XmlElement element, IntrospectedTable introspectedTable, boolean hasPrefix) {
        List<XmlElement> ifs;
        List<XmlElement> sets;
        if (this.incTools.support() && (sets = XmlElementTools.findXmlElements(element, "set")).size() > 0 && (ifs = XmlElementTools.findXmlElements(sets.get(0), "if")).size() > 0) {
            for (XmlElement xmlElement : ifs) {
                List textEles = xmlElement.getElements();
                TextElement textEle = (TextElement)textEles.get(0);
                String[] strs = textEle.getContent().split("=");
                String columnName = strs[0].trim();
                IntrospectedColumn introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                List<Element> incrementEles = PluginTools.getHook(IIncrementsPluginHook.class).incrementSetElementGenerated(introspectedColumn, hasPrefix ? "record." : null, true);
                if (incrementEles.isEmpty()) continue;
                xmlElement.getElements().clear();
                xmlElement.getElements().addAll(incrementEles);
            }
        }
    }

    private void generatedWithoutSelective(XmlElement xmlElement, IntrospectedTable introspectedTable, boolean hasPrefix) {
        if (this.incTools.support()) {
            ArrayList<Element> newEles = new ArrayList<Element>();
            for (Element ele : xmlElement.getElements()) {
                String text;
                if (ele instanceof TextElement && (text = ((TextElement)ele).getContent().trim()).matches("(^set\\s)?\\S+\\s?=.*")) {
                    text = text.replaceFirst("^set\\s", "").trim();
                    String columnName = text.split("=")[0].trim();
                    IntrospectedColumn introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                    List<Element> incrementEles = PluginTools.getHook(IIncrementsPluginHook.class).incrementSetElementGenerated(introspectedColumn, hasPrefix ? "record." : null, text.endsWith(","));
                    if (!incrementEles.isEmpty()) {
                        newEles.addAll(incrementEles);
                        continue;
                    }
                }
                newEles.add(ele);
            }
            xmlElement.getElements().clear();
            xmlElement.getElements().addAll(newEles);
        }
    }
}

