/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.IncrementsPlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;

public class IncrementsPluginTools {
    private IntrospectedTable introspectedTable;
    private List<IntrospectedColumn> columns = new ArrayList<IntrospectedColumn>();

    private IncrementsPluginTools(IntrospectedTable introspectedTable) {
        this.introspectedTable = introspectedTable;
    }

    public static IncrementsPluginTools getTools(Context context, IntrospectedTable introspectedTable, List<String> warnings) {
        String incrementsColumns;
        IncrementsPluginTools tools = new IncrementsPluginTools(introspectedTable);
        if (PluginTools.getPluginConfiguration(context, IncrementsPlugin.class) != null && StringUtility.stringHasValue((String)(incrementsColumns = introspectedTable.getTableConfigurationProperty("incrementsColumns")))) {
            String[] incrementsColumnsStrs;
            for (String incrementsColumnsStr : incrementsColumnsStrs = incrementsColumns.split(",")) {
                IntrospectedColumn column = IntrospectedTableTools.safeGetColumn(introspectedTable, incrementsColumnsStr);
                if (column == null) {
                    warnings.add("itfsw:\u63d2\u4ef6" + IncrementsPlugin.class.getTypeName() + "\u63d2\u4ef6\u6ca1\u6709\u627e\u5230column\u4e3a" + incrementsColumnsStr.trim() + "\u7684\u5b57\u6bb5\uff01");
                    continue;
                }
                tools.columns.add(column);
            }
        }
        return tools;
    }

    public FullyQualifiedJavaType getIncEnum() {
        return new FullyQualifiedJavaType(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName() + "." + "Builder" + ".Inc");
    }

    public boolean support() {
        return this.columns.size() > 0;
    }

    public List<IntrospectedColumn> getColumns() {
        return this.columns;
    }

    public boolean supportColumn(IntrospectedColumn searchColumn) {
        for (IntrospectedColumn column : this.columns) {
            if (!column.getActualColumnName().equals(searchColumn.getActualColumnName())) continue;
            return true;
        }
        return false;
    }
}

