/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class XmlElementTools {
    public static Attribute getAttribute(XmlElement element, String name) {
        for (Attribute attribute : element.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public static void removeAttribute(XmlElement element, String name) {
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(name)) continue;
            iterator.remove();
        }
    }

    public static void replaceAttribute(XmlElement element, Attribute attribute) {
        XmlElementTools.removeAttribute(element, attribute.getName());
        element.addAttribute(attribute);
    }

    public static void replaceXmlElement(XmlElement srcEle, XmlElement destEle) {
        srcEle.setName(destEle.getName());
        srcEle.getAttributes().clear();
        srcEle.getAttributes().addAll(destEle.getAttributes());
        srcEle.getElements().clear();
        srcEle.getElements().addAll(destEle.getElements());
    }

    public static List<XmlElement> findXmlElements(XmlElement xmlElement, String name) {
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        List elements = xmlElement.getElements();
        for (Element ele : elements) {
            XmlElement xmlElement1;
            if (!(ele instanceof XmlElement) || !name.equalsIgnoreCase((xmlElement1 = (XmlElement)ele).getName())) continue;
            list.add(xmlElement1);
        }
        return list;
    }

    public static List<TextElement> findAllTextElements(XmlElement xmlElement) {
        ArrayList<TextElement> textElements = new ArrayList<TextElement>();
        for (Element element : xmlElement.getElements()) {
            if (element instanceof XmlElement) {
                textElements.addAll(XmlElementTools.findAllTextElements((XmlElement)element));
                continue;
            }
            if (!(element instanceof TextElement)) continue;
            textElements.add((TextElement)element);
        }
        return textElements;
    }

    public static XmlElement clone(XmlElement element) {
        XmlElement destEle = new XmlElement(element.getName());
        for (Attribute attribute : element.getAttributes()) {
            destEle.addAttribute(XmlElementTools.clone(attribute));
        }
        for (Element ele : element.getElements()) {
            if (ele instanceof XmlElement) {
                destEle.addElement((Element)XmlElementTools.clone((XmlElement)ele));
                continue;
            }
            if (!(ele instanceof TextElement)) continue;
            destEle.addElement((Element)XmlElementTools.clone((TextElement)ele));
        }
        return destEle;
    }

    public static Attribute clone(Attribute attribute) {
        return new Attribute(attribute.getName(), attribute.getValue());
    }

    public static TextElement clone(TextElement textElement) {
        return new TextElement(textElement.getContent());
    }
}

