package com.kirkk.analyzer.framework;

import com.kirkk.analyzer.framework.jar.JarFile;
import java.io.*;
import java.util.*;
import java.util.zip.ZipException;


public class Analyzer {
	private ResourceBundle resourceBundle;

    public Analyzer() throws Exception {
		this.resourceBundle = ResourceBundle.getBundle("com.kirkk.analyzer.framework.Analyzer");
	}

    public JarBundle[] analyze(File file) throws Exception {
        JarBundleBuilder jarbundlebuilder = getBundleBuilder();
        JarBundle jarBundle[] = jarbundlebuilder.getBundle(file, Configuration.ignorePackages, Configuration.ignoreJars);
        return jarBundle;
    }

    private JarBundleBuilder getBundleBuilder() throws Exception {
        Class class1 = null;
        String defaultClassName = "com.kirkk.analyzer.framework.bcelbundle.BCELBundleBuilder";
        String className = resourceBundle.getString("JarBundleBuilder.classname");
        try {
            class1 = Class.forName(className);
        } catch(ClassNotFoundException e) {
			try {
                class1 = Class.forName(defaultClassName);
            } catch (ClassNotFoundException ex) {
                throw ex;
            }
        }
        return (JarBundleBuilder)class1.newInstance();
    }
}
