package com.kirkk.analyzer.framework.bcelbundle;

import java.util.*;
import com.kirkk.analyzer.framework.*;
import com.kirkk.analyzer.framework.jar.JarFile;
import java.io.*;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import java.util.zip.ZipException;

public class BCELBundleBuilder implements JarBundleBuilder {

    public JarBundle[] getBundle(File file, List ignorePackages, List ignoreJars) throws Exception {
		if (file.isDirectory()) {
			throw new IOException("File must be a filename.");
		}
		JarFile jarFile = this.getJarFile(file);
        BCELJarBundle bcelJarBundle = new BCELJarBundle(jarFile.getFileName());
        while (jarFile.hasMoreClasses()) {
            String className = jarFile.nextClass();
            try {
                JavaClass javaClass = getClass(jarFile, className);
                BCELPublicClass bcelPublicClass = new BCELPublicClass(javaClass, ignorePackages);
                String packageName = javaClass.getPackageName();
                BCELJavaPackage javaPackage = null;
                if(bcelJarBundle.containsPackage(packageName)) {
                    javaPackage = (BCELJavaPackage)bcelJarBundle.getPackage(packageName);
                } else {
                    javaPackage = new BCELJavaPackage(packageName);
                    bcelJarBundle.addPackage(javaPackage);
                }
                javaPackage.addClass(bcelPublicClass);
                //System.out.println("  javaClass: " + bcelPublicClass.getLongName());
            }
            catch(IOException e) {
                e.printStackTrace();
            }
        }
        jarFile.close();
        BCELJarBundle bundle[] = new BCELJarBundle[1];
        bundle[0] = bcelJarBundle;
        return bundle;
    }

    private JavaClass getClass(JarFile jarfile, String s) throws IOException {
        ClassParser classParser = new ClassParser(jarfile.getFileName(), s);
        JavaClass javaClass = classParser.parse();
        return javaClass;
    }

    private JarFile getJarFile(File file) {
		JarFile jarfile = null;
		try {
			jarfile = new JarFile(file);
		} catch(ZipException e) {
			//System.out.println("HERE");
			//System.out.println(file);
		    e.printStackTrace();
		} catch(IOException e) {
		    e.printStackTrace();
        }
        return jarfile;
	}
}
