package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.*;
import com.kirkk.analyzer.framework.jar.JarFile;
import java.io.*;
import java.util.*;

public class BCELDependencyBundleBuilder implements JarBundleBuilder {
	public JarBundle[] getBundle(File file, List ignorePackages, List ignoreJars) throws Exception {

		//JarBundle jarBundles[] = this.getJarBundles(file);
		List jarBundles = this.getJarBundles(file, ignorePackages);
		/*ArrayList list = new ArrayList();
		for (int i = 0; i < jarBundles.length; i++) {
			list.add(jarBundles[i]);
		}*/
		this.establishBundleRelationships(jarBundles);
		Iterator jarBundleIterator = jarBundles.iterator();
		ArrayList finalBundle = new ArrayList();
		while (jarBundleIterator.hasNext()) {
			JarBundle jarBundle = (JarBundle) jarBundleIterator.next();
			if (ignoreJars.isEmpty() == false) {
				if (!ignoreJars.contains(jarBundle.getJarFileName())) {
					finalBundle.add(jarBundle);
				}
			} else {
				finalBundle.add(jarBundle);
			}
		}

		JarBundle jarBundleArray[] = new JarBundle[finalBundle.size()];
		int i = 0;
		Iterator finalBundleIterator = finalBundle.iterator();
		while (finalBundleIterator.hasNext()) {
			jarBundleArray[i] = (JarBundle) finalBundleIterator.next();
			i++;
		}

		return jarBundleArray;

	}

	private List getJarBundles(File file, List ignorePackages) throws Exception {
		if (file.isDirectory()) {
			File files[] = this.getJarFiles(file);
			//JarBundle jarBundles[] = new JarBundle[files.length];
			ArrayList jarBundles = new ArrayList();
			for (int i = 0; i < files.length; i++) {
				BCELBundleBuilder bundleBuilder = new BCELBundleBuilder();
				//jarBundles[i] = bundleBuilder.getBundle(files[i])[0];
				JarBundle jarBundle = bundleBuilder.getBundle(files[i], ignorePackages, null)[0];
				if (jarBundle.getPublicClassCount() > 0) {
					jarBundles.add(jarBundle);
				}
				//System.out.println(jarBundles[i].getJarFileName());
			}
			return jarBundles;

		} else {
			throw new IOException("File must be a directory");
		}

	}

	private File[] getJarFiles(File file) {
		FilenameFilter filter = new FilenameFilter() {
			public boolean accept(File file, String fileName) {
				if (fileName.endsWith(".jar")) {
					return true;
				} else {
					return false;
				}
			}
		};

		return file.listFiles(filter);

	}

	private void establishBundleRelationships(List jarBundles) throws Exception {
		Iterator jars = jarBundles.iterator();
		while (jars.hasNext()) {
			JarBundle jarBundle = (JarBundle) jars.next();
			Iterator otherJars = jarBundles.iterator();
			while (otherJars.hasNext()) {
				JarBundle otherBundle = (JarBundle) otherJars.next();
				if (jarBundle == otherBundle) {
					continue;
				} else {
					Iterator externalImports = jarBundle.getAllExternallyReferencedPackages().iterator();
					Iterator internalPackages = otherBundle.getAllContainedPackages().iterator();
					while (externalImports.hasNext()) {
						String packageName = (String) externalImports.next();
						if (otherBundle.containsPackage(packageName)) {
							((BCELJarBundle)jarBundle).addDependentJar(otherBundle);
						}
					}
				}
			}
		}
	}
}