package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.JarBundle;
import com.kirkk.analyzer.framework.JavaPackage;
import java.util.*;

public class BCELJarBundle implements JarBundle {

    public List packages = new ArrayList();
    private List dependentJars = new ArrayList();
    private String jarFileName;

	public BCELJarBundle(String jarFileName) {
		this.jarFileName = jarFileName;
	}


 	public int getLevel() {
		int jarLevel = 1;
		if ( (this.dependentJars == null) || (this.dependentJars.size() == 0) ) {
			return jarLevel;
		} else {
			Iterator jars = this.dependentJars.iterator();
			while (jars.hasNext()) {
				JarBundle jar = (JarBundle) jars.next();
				int currLevel = jar.getLevel();
				if (currLevel >= jarLevel) {
					jarLevel = currLevel + 1;
				}
			}
		}
		return jarLevel;
	}

    public List getAllContainedPackages() {
        return packages;
    }

	public void addDependentJar(JarBundle jarBundle) {
		if (this.dependentJars == null) {
			this.dependentJars = new ArrayList();
		}
		if (!this.dependentJars.contains(jarBundle)) {
			this.dependentJars.add(jarBundle);
		}
	}

	public List getDependentJars() {
		return this.dependentJars;
	}

	public List getAllExternallyReferencedPackages() {
		Iterator allPackages = this.getAllContainedPackages().iterator();
		ArrayList externalImports = new ArrayList();
		while (allPackages.hasNext()) {
			JavaPackage javaPackage = (JavaPackage) allPackages.next();
			Iterator dependencies = javaPackage.getImportedPackageNames().iterator();
			while (dependencies.hasNext()) {
				String dependentPackage = (String) dependencies.next();
				if ( (this.containsPackage(dependentPackage) == false) &&
					 (externalImports.contains(dependentPackage) == false) ) {
					externalImports.add(dependentPackage);
				}

			}
		}
		return externalImports;
	}

	public List getAllUnidentifiableExternallyReferencedPackages() {
		Iterator externalPackages = this.getAllExternallyReferencedPackages().iterator();
		ArrayList unresolvablePackages = new ArrayList();
		while (externalPackages.hasNext()) {
			String packageName = (String) externalPackages.next();
			Iterator dependencies = this.dependentJars.iterator();
			boolean packageFound = false;
			while (dependencies.hasNext()) {
				JarBundle jarBundle = (JarBundle) dependencies.next();
				if (jarBundle.containsPackage(packageName)) {
					packageFound = true;
				}
			}
			if ( (!packageFound) && (!unresolvablePackages.contains(packageName)) ) {
				unresolvablePackages.add(packageName);
			}
		}
		return unresolvablePackages;
	}

	public int getPackageCount() {
		return this.packages.size();
	}

	public String getJarFileName() {
		return this.jarFileName.substring(this.jarFileName.lastIndexOf("\\") + 1,
															this.jarFileName.length());
	}

	public String getFullyQualifiedJarFileName() {
		return this.jarFileName;
	}

	public int getPublicClassCount() {
		Iterator p = this.packages.iterator();
		int classCount = 0;
		while (p.hasNext()) {
			JavaPackage pkg = (JavaPackage) p.next();
			classCount += pkg.getPublicClassCount();
		}

		return classCount;
	}

    public void addPackage(JavaPackage javapackage) {
        packages.add(javapackage);
    }

    public JavaPackage getPackage(String s) {
        BCELJavaPackage bceljavapackage = new BCELJavaPackage(s);
        int i = packages.indexOf(bceljavapackage);
        return (JavaPackage)packages.get(i);
    }

    public boolean containsPackage(String s) {
        if(packages == null) {
            return false;
		}
        BCELJavaPackage bceljavapackage = new BCELJavaPackage(s);
        return packages.contains(bceljavapackage);
    }
}
