package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.JavaPackage;
import com.kirkk.analyzer.framework.PublicClass;
import java.util.*;

public class BCELJavaPackage implements JavaPackage {

    private String packageName;
    private List publicClasses;

    public BCELJavaPackage(String packageName) {
        if(packageName== null) {
            throw new NullPointerException("Package name cannot be null");
        } else {
            this.packageName = packageName;
        }
    }

    void addClass(PublicClass publicclass) {
        if(publicClasses == null)
            publicClasses = new ArrayList();
        publicClasses.add(publicclass);
    }

    public List getPublicClasses() {
		Iterator classIterator = this.publicClasses.iterator();
		List publicList = new ArrayList();
		while (classIterator.hasNext()) {
			PublicClass cls = (PublicClass) classIterator.next();
			if (cls.isPublic()) {
				publicList.add(cls);
			}
		}
        return publicList;
    }

    public int getPublicClassCount() {
		return this.publicClasses.size();
	}

    public String getLongName() {
        return this.packageName;
    }

    public boolean equals(Object obj) {
        if(obj instanceof JavaPackage) {
            JavaPackage javapackage = (JavaPackage)obj;
            if(getLongName().equals(javapackage.getLongName())) {
                return true;
			}
        }
        return false;
    }

    public int hashCode() {
        return packageName.hashCode();
    }

    public List getImportedPackageNames() {
		List importedPackages = new ArrayList();
		Iterator classes = publicClasses.iterator();
		while (classes.hasNext()) {
			PublicClass cls = (PublicClass) classes.next();
			Iterator packages = cls.getImportedPackageNames().iterator();
			while (packages.hasNext()) {
				String packageName = (String) packages.next();
				if (!importedPackages.contains(packageName)) {
					importedPackages.add(packageName);
				}
			}
		}
		return importedPackages;
	}
}
