package com.kirkk.analyzer.framework.jar;

import java.io.*;
import java.util.zip.*;
import java.util.*;

public class JarFile {
	private HashMap jarContents;
	private Enumeration jarEntries;
    private ZipFile zipFile;
	private String nextClass;
	private File file;

	public JarFile(File file)  throws ZipException, IOException {
		this.file = file;
            zipFile =  new ZipFile(file);
		jarEntries = zipFile.entries();
	}

	public boolean hasMoreClasses() {
		boolean classFileFound = false;
		ZipEntry nextEntry = null;
		while (jarEntries.hasMoreElements() && (classFileFound == false) ) {
			nextEntry = (ZipEntry) jarEntries.nextElement();
			/*if ( (nextEntry.getName().endsWith(".class")) &&
				 (nextEntry.getName().indexOf("$") == -1 ) ) {
					 classFileFound = true;
			}*/
			if ( (nextEntry.getName().endsWith(".class")) ) {
				classFileFound = true;
			}
		}
		if (classFileFound) {
			this.nextClass = nextEntry.getName();
			return true;
		} else {
			this.nextClass = null;
			return false;
		}
		//return jarEntries.hasMoreElements();
	}

	public String nextClass() {
		return this.nextClass;
	}
	/*public String nextClass() {
		boolean lookingForClassFile = true;
		ZipEntry nextEntry = null;
		while ( (lookingForClassFile) && (jarEntries.hasMoreElements()) ) {
			nextEntry = (ZipEntry) jarEntries.nextElement();
			if ( (nextEntry.getName().endsWith(".class")) &&
				 (nextEntry.getName().indexOf("$") == -1 ) ) {
				lookingForClassFile = false;
			}
		}
		System.out.println(nextEntry.getName());
		return nextEntry.getName();
	}*/

	public String getFileName() {
		return this.file.getAbsolutePath();
	}

    public void close() {
        if(null != zipFile) {
            try {
                zipFile.close();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }
}