/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalIntIntMapOps;
import com.koloboke.collect.map.IntIntMap;
import com.koloboke.function.IntIntConsumer;
import com.koloboke.function.IntIntPredicate;
import java.util.Map;

public final class CommonIntIntMapOps {
    public static boolean containsAllEntries(final InternalIntIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntIntMap) {
            IntIntMap m2 = (IntIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntIntMapOps) {
                return ((InternalIntIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntIntPredicate(){

                public boolean test(int a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntIntMapOps map, Map<? extends Integer, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntIntMap) {
            if (another instanceof InternalIntIntMapOps) {
                ((InternalIntIntMapOps)another).reversePutAllTo(map);
            } else {
                ((IntIntMap)another).forEach(new IntIntConsumer(){

                    public void accept(int key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntIntMapOps() {
    }
}

