/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortCollectionOps;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.function.ShortConsumer;
import com.koloboke.function.ShortPredicate;
import java.util.Collection;

public final class CommonShortCollectionOps {
    public static boolean containsAll(final ShortCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof ShortCollection) {
            ShortCollection c2 = (ShortCollection)another;
            if (collection instanceof ShortSet && c2 instanceof ShortSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalShortCollectionOps) {
                return ((InternalShortCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new ShortPredicate(){

                public boolean test(short value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Short)o).shortValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(ShortCollection collection, Collection<? extends Short> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortCollection) {
            if (another instanceof InternalShortCollectionOps) {
                return ((InternalShortCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements ShortConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ ShortCollection val$collection;

                AddAll(ShortCollection shortCollection) {
                    this.val$collection = shortCollection;
                }

                public void accept(short value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((ShortCollection)another).forEach((ShortConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Short s : another) {
            collectionChanged |= collection.add(s.shortValue());
        }
        return collectionChanged;
    }

    private CommonShortCollectionOps() {
    }
}

