/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSBuilderUtil {
    private static final Pattern _cssImportPattern = Pattern.compile("@import\\s+url\\s*\\(\\s*['\"]?(.+\\.css)");

    public static File getOutputFile(String fileName, String outputDirName) {
        return CSSBuilderUtil.getOutputFile(fileName, outputDirName, "");
    }

    public static File getOutputFile(String fileName, String outputDirName, String suffix) {
        return new File(CSSBuilderUtil.getOutputFileName(fileName, outputDirName, suffix));
    }

    public static String getOutputFileName(String fileName, String outputDirName, String suffix) {
        String cacheFileName = StringUtil.replace(fileName, '\\', '/');
        int x = cacheFileName.lastIndexOf(47);
        int y = cacheFileName.lastIndexOf(46);
        if (cacheFileName.endsWith(".scss")) {
            cacheFileName = cacheFileName.substring(0, y + 1) + "css";
        }
        return StringBundler.concat(cacheFileName.substring(0, x + 1), outputDirName, cacheFileName.substring(x + 1, y), suffix, cacheFileName.substring(y));
    }

    public static String getRtlCustomFileName(String fileName) {
        int pos = fileName.lastIndexOf(46);
        return fileName.substring(0, pos) + "_rtl" + fileName.substring(pos);
    }

    public static String parseCSSImports(String content) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _cssImportPattern.matcher(content);
        Date date = new Date();
        while (matcher.find()) {
            String cssImport = matcher.group();
            matcher.appendReplacement(sb, cssImport + "?t=" + date.getTime());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String parseStaticTokens(String content) {
        return StringUtil.replace(content, new String[]{"@model_hints_constants_text_display_height@", "@model_hints_constants_text_display_width@", "@model_hints_constants_textarea_display_height@", "@model_hints_constants_textarea_display_width@"}, new String[]{"15", "210", "100", "500"});
    }
}

