/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder.internal.util;

import com.liferay.css.builder.CSSBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.apache.tools.ant.DirectoryScanner;

public class FileUtil {
    public static void deltree(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String[] getFilesFromDirectory(String baseDir, String[] includes, String[] excludes) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(baseDir);
        directoryScanner.setExcludes(excludes);
        directoryScanner.setIncludes(includes);
        directoryScanner.scan();
        return directoryScanner.getIncludedFiles();
    }

    public static File getJarFile() throws Exception {
        ProtectionDomain protectionDomain = CSSBuilder.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    public static long getLastModifiedTime(Path path) {
        try {
            FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            return fileTime.toMillis();
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    public static boolean isAbsolute(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        return path.isAbsolute();
    }

    public static void write(File file, String content) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        Path path = Paths.get(file.toURI());
        Files.write(path, content.getBytes("UTF-8"), new OpenOption[0]);
    }
}

