/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.main;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.GroovyCodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.Root;
import com.manydesigns.portofino.dispatcher.resolvers.CachingResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.GroovyResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.JavaResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.swagger.DocumentedApiRoot;
import com.manydesigns.portofino.dispatcher.web.ApplicationRoot;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import java.io.File;
import java.net.URI;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyMain {
    private static Logger logger = LoggerFactory.getLogger(GrizzlyMain.class);

    public static void main(String[] args) throws Exception {
        FileObject codeBaseRoot;
        File currentDirectory = new File("");
        FileSystemManager manager = VFS.getManager();
        if (manager instanceof DefaultFileSystemManager) {
            ((DefaultFileSystemManager)manager).setBaseFile(currentDirectory);
        }
        String rootPath = currentDirectory.getAbsolutePath();
        if (args.length > 0) {
            rootPath = args[0];
        }
        try {
            codeBaseRoot = VFS.getManager().resolveFile("res:");
        }
        catch (Exception e) {
            codeBaseRoot = VFS.getManager().resolveFile("res:com/manydesigns/portofino/dispatcher/main/GrizzlyMain.class").getParent().getParent().getParent().getParent().getParent().getParent();
        }
        JavaCodeBase codeBase = new JavaCodeBase(codeBaseRoot);
        codeBase = new GroovyCodeBase(codeBaseRoot, (CodeBase)codeBase);
        ResourceResolvers resourceResolver = new ResourceResolvers();
        resourceResolver.resourceResolvers.add(new JavaResourceResolver((CodeBase)codeBase));
        resourceResolver.resourceResolvers.add(new GroovyResourceResolver((CodeBase)codeBase));
        FileObject root = manager.resolveFile(rootPath);
        logger.info("Codebase rootFactory: " + codeBaseRoot.getURL());
        logger.info("Root path: " + root.getURL());
        DocumentedApiRoot.setRootFactory(() -> Root.get(root, resourceResolver));
        String host = System.getProperty("portofino.web.host", "0.0.0.0");
        String port = System.getProperty("portofino.web.port", "8090");
        ResourceConfig config = new ResourceConfig(new Class[]{ApplicationRoot.class, OpenApiResource.class});
        config.property("jersey.config.servlet.filter.forwardOn404", (Object)true);
        try {
            config.register(Class.forName("org.glassfish.jersey.jackson.JacksonFeature"));
            ResourceResolver jacksonRR = (ResourceResolver)Class.forName("com.manydesigns.portofino.dispatcher.resolvers.JacksonResourceResolver").newInstance();
            resourceResolver.resourceResolvers.add(new CachingResourceResolver(jacksonRR));
        }
        catch (ClassNotFoundException jacksonRR) {
            // empty catch block
        }
        try {
            config.register(Class.forName("com.manydesigns.portofino.dispatcher.security.ShiroResourceFilter"));
        }
        catch (ClassNotFoundException jacksonRR) {
            // empty catch block
        }
        URI uri = URI.create("http://" + host + ":" + port + "/");
        HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)config);
        ClassLoader loader = GrizzlyMain.class.getClassLoader();
        CLStaticHttpHandler webjarsHandler = new CLStaticHttpHandler(loader, new String[]{"META-INF/resources/webjars/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)webjarsHandler, new String[]{"/webjars/"});
        httpServer.start();
    }
}

