/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.manydesigns.portofino.dispatcher.ResourceResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingResourceResolver
implements ResourceResolver {
    private final ConcurrentMap<String, Cached> cache = new ConcurrentHashMap<String, Cached>();
    protected static final Logger logger = LoggerFactory.getLogger(CachingResourceResolver.class);
    protected ResourceResolver delegate;

    protected CachingResourceResolver() {
    }

    public CachingResourceResolver(ResourceResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.delegate.supports(type);
    }

    @Override
    public boolean supports(String extension) {
        return this.delegate.supports(extension);
    }

    @Override
    public <T> T resolve(FileObject location, Class<T> type) throws Exception {
        if (location == null) {
            return null;
        }
        if ((location = this.resolve(location)) == null) {
            return null;
        }
        String key = location.getName().getURI() + " " + type.getName();
        Cached cached = (Cached)this.cache.get(key);
        if (cached == null) {
            return this.cache((String)key, (FileObject)location, type).value;
        }
        long lastModifiedTime = this.getLastModifiedTime(location);
        if (lastModifiedTime > cached.timestamp) {
            logger.debug("Timestamp for {} is {}, was cached with last-modified time {}", new Object[]{location, lastModifiedTime, cached.timestamp});
            return this.cache((String)key, (FileObject)location, type).value;
        }
        return type.cast(cached.value);
    }

    @Override
    public FileObject resolve(FileObject location) throws FileSystemException {
        return this.delegate.resolve(location);
    }

    @Override
    public FileObject resolve(FileObject location, String name) throws FileSystemException {
        return this.delegate.resolve(location, name);
    }

    @Override
    public <T> T resolve(FileObject location, String name, Class<T> type) throws Exception {
        return this.resolve(this.resolve(location, name), type);
    }

    protected long getLastModifiedTime(FileObject location) throws FileSystemException {
        return location.getContent().getLastModifiedTime();
    }

    protected <T> Cached<T> cache(String key, FileObject location, Class<T> type) throws Exception {
        Cached<T> value = this.resolveForCache(location, type);
        this.cache.put(key, value);
        return value;
    }

    protected <T> Cached<T> resolveForCache(FileObject location, Class<T> type) throws Exception {
        return new Cached<T>(this.doResolve(location, type), location.getContent().getLastModifiedTime());
    }

    protected <T> T doResolve(FileObject location, Class<T> type) throws Exception {
        return this.delegate.resolve(location, type);
    }

    public void clearCache(long maxAge) {
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Cached> entry : this.cache.entrySet()) {
            if (now - ((Cached)entry.getValue()).timestamp <= maxAge) continue;
            this.removeCacheEntry(entry);
        }
    }

    protected Cached removeCacheEntry(Map.Entry<String, Cached> entry) {
        return (Cached)this.cache.remove(entry.getKey());
    }

    public static class Cached<T> {
        public final T value;
        public final long timestamp;

        public Cached(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

