/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher;

import com.manydesigns.portofino.dispatcher.AbstractResource;
import com.manydesigns.portofino.dispatcher.WithParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;

public abstract class AbstractResourceWithParameters
extends AbstractResource
implements WithParameters {
    public static final String COPYRIGHT = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected int minParameters = 0;
    protected int maxParameters = 1;
    protected final List<String> parameters = new ArrayList<String>();

    @Override
    @Path(value="{pathSegment}")
    public Object consumePathSegment(@PathParam(value="pathSegment") String pathSegment) {
        if (this.parameters.size() < this.minParameters) {
            this.consumeParameter(pathSegment);
            return this;
        }
        try {
            Object element = super.consumePathSegment(pathSegment);
            this.parametersAcquired();
            return element;
        }
        catch (WebApplicationException e) {
            logger.debug("Invalid subresource: " + pathSegment, (Throwable)e);
            if (this.parameters.size() < this.maxParameters) {
                this.consumeParameter(pathSegment);
                if (this.parameters.size() == this.maxParameters) {
                    this.parametersAcquired();
                }
                return this;
            }
            throw new WebApplicationException("Too many path parameters", 404);
        }
    }

    @Override
    public void consumeParameter(String pathSegment) {
        this.parameters.add(pathSegment);
    }

    protected void parametersAcquired() throws WebApplicationException {
        if (this.parameters.size() < this.minParameters) {
            throw new WebApplicationException("Too few path parameters", 404);
        }
    }

    @Override
    public String getPath() {
        StringBuilder path = new StringBuilder(super.getPath());
        for (String param : this.parameters) {
            path = path.append(param).append("/");
        }
        return path.toString();
    }

    @Override
    public int getMinParameters() {
        return this.minParameters;
    }

    @Override
    public int getMaxParameters() {
        return this.maxParameters;
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getParameterName(int index) {
        if (index < this.getMinParameters()) {
            return "requiredPathParameter_" + index;
        }
        return "optionalPathParameter_" + index;
    }

    @Override
    public Map<String, Object> describe() {
        Map<String, Object> description = super.describe();
        description.put("minParameters", this.minParameters);
        description.put("maxParameters", this.maxParameters);
        description.put("parameters", this.parameters);
        return description;
    }
}

