/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractParameterResultSetHandler
extends AbstractResultSetHandler {
    private boolean exactMatchParameter = false;
    private Map resultSetsForStatement = new TreeMap();
    private Map updateCountForStatement = new TreeMap();
    private Map throwsSQLException = new TreeMap();
    private Map generatedKeysForStatement = new TreeMap();
    private Map executedStatementParameters = new TreeMap();

    public void addParameterMapForExecutedStatement(String sql, Map parameters) {
        if (null != parameters) {
            if (null == this.executedStatementParameters.get(sql)) {
                this.executedStatementParameters.put(sql, new ParameterSets(sql));
            }
            ParameterSets sets = (ParameterSets)this.executedStatementParameters.get(sql);
            sets.addParameterSet(parameters);
        }
    }

    public ParameterSets getParametersForExecutedStatement(String sql) {
        return (ParameterSets)this.executedStatementParameters.get(sql);
    }

    public Map getExecutedStatementParameterMap() {
        return Collections.unmodifiableMap(this.executedStatementParameters);
    }

    public Map getExecutedStatementParameter() {
        return this.getExecutedStatementParameterMap();
    }

    public void setExactMatchParameter(boolean exactMatchParameter) {
        this.exactMatchParameter = exactMatchParameter;
    }

    public Integer getUpdateCount(String sql, Map parameters) {
        Integer[] updateCounts = this.getUpdateCounts(sql, parameters);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return null;
    }

    public Integer[] getUpdateCounts(String sql, Map parameters) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.updateCountForStatement);
        if (null != wrapper) {
            if (wrapper instanceof MockUpdateCountWrapper) {
                return new Integer[]{((MockUpdateCountWrapper)wrapper).getUpdateCount()};
            }
            if (wrapper instanceof MockUpdateCountArrayWrapper) {
                return ((MockUpdateCountArrayWrapper)wrapper).getUpdateCount();
            }
        }
        return null;
    }

    public boolean hasMultipleUpdateCounts(String sql, Map parameters) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.updateCountForStatement);
        return wrapper instanceof MockUpdateCountArrayWrapper;
    }

    public MockResultSet getResultSet(String sql, Map parameters) {
        MockResultSet[] resultSets = this.getResultSets(sql, parameters);
        if (null != resultSets && resultSets.length > 0) {
            return resultSets[0];
        }
        return null;
    }

    public MockResultSet[] getResultSets(String sql, Map parameters) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.resultSetsForStatement);
        if (null != wrapper) {
            if (wrapper instanceof MockResultSetWrapper) {
                return new MockResultSet[]{((MockResultSetWrapper)wrapper).getResultSet()};
            }
            if (wrapper instanceof MockResultSetArrayWrapper) {
                return ((MockResultSetArrayWrapper)wrapper).getResultSets();
            }
        }
        return null;
    }

    public boolean hasMultipleResultSets(String sql, Map parameters) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.resultSetsForStatement);
        return wrapper instanceof MockResultSetArrayWrapper;
    }

    public boolean getThrowsSQLException(String sql, Map parameters) {
        return this.getSQLException(sql, parameters) != null;
    }

    public SQLException getSQLException(String sql, Map parameters) {
        MockSQLExceptionWrapper wrapper = (MockSQLExceptionWrapper)this.getMatchingParameterWrapper(sql, parameters, this.throwsSQLException);
        if (null != wrapper) {
            return wrapper.getException();
        }
        return null;
    }

    public MockResultSet getGeneratedKeys(String sql, Map parameters) {
        MockResultSetWrapper wrapper = (MockResultSetWrapper)this.getMatchingParameterWrapper(sql, parameters, this.generatedKeysForStatement);
        if (null != wrapper) {
            return wrapper.getResultSet();
        }
        return null;
    }

    protected ParameterWrapper getMatchingParameterWrapper(String sql, Map parameters, Map statementMap) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(statementMap, sql, true, true);
        for (int ii = 0; ii < list.size(); ++ii) {
            ParameterWrapper wrapper = (ParameterWrapper)list.get(ii);
            if (!this.doParameterMatch(wrapper.getParamters(), parameters)) continue;
            return wrapper;
        }
        return null;
    }

    private boolean doParameterMatch(Map expectedParameters, Map actualParameters) {
        if (this.exactMatchParameter) {
            if (actualParameters.size() != expectedParameters.size()) {
                return false;
            }
            for (Object currentKey : actualParameters.keySet()) {
                if (!actualParameters.containsKey(currentKey)) {
                    return false;
                }
                Object expectedObject = expectedParameters.get(currentKey);
                if (ParameterUtil.compareParameter(actualParameters.get(currentKey), expectedObject)) continue;
                return false;
            }
            return true;
        }
        for (Object currentKey : expectedParameters.keySet()) {
            if (!actualParameters.containsKey(currentKey)) {
                return false;
            }
            Object actualObject = actualParameters.get(currentKey);
            if (ParameterUtil.compareParameter(actualObject, expectedParameters.get(currentKey))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearResultSets() {
        super.clearResultSets();
        this.resultSetsForStatement.clear();
    }

    @Override
    public void clearUpdateCounts() {
        super.clearUpdateCounts();
        this.updateCountForStatement.clear();
    }

    @Override
    public void clearThrowsSQLException() {
        super.clearThrowsSQLException();
        this.throwsSQLException.clear();
    }

    @Override
    public void clearGeneratedKeys() {
        super.clearGeneratedKeys();
        this.generatedKeysForStatement.clear();
    }

    public void prepareResultSet(String sql, MockResultSet resultSet, Object[] parameters) {
        this.prepareResultSet(sql, resultSet, Arrays.asList(parameters));
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets, Object[] parameters) {
        this.prepareResultSets(sql, resultSets, Arrays.asList(parameters));
    }

    public void prepareResultSet(String sql, MockResultSet resultSet, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareResultSet(sql, resultSet, params);
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareResultSets(sql, resultSets, params);
    }

    public void prepareResultSet(String sql, MockResultSet resultSet, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.resultSetsForStatement);
        list.add(new MockResultSetWrapper(resultSet, new HashMap(parameters)));
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.resultSetsForStatement);
        list.add(new MockResultSetArrayWrapper((MockResultSet[])resultSets.clone(), new HashMap(parameters)));
    }

    public void prepareThrowsSQLException(String sql, Object[] parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    public void prepareThrowsSQLException(String sql, List parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    public void prepareThrowsSQLException(String sql, Map parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    public void prepareThrowsSQLException(String sql, SQLException exc, Object[] parameters) {
        this.prepareThrowsSQLException(sql, exc, Arrays.asList(parameters));
    }

    public void prepareThrowsSQLException(String sql, SQLException exc, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareThrowsSQLException(sql, exc, params);
    }

    public void prepareThrowsSQLException(String sql, SQLException exc, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.throwsSQLException);
        list.add(new MockSQLExceptionWrapper(exc, new HashMap(parameters)));
    }

    public void prepareUpdateCount(String sql, int updateCount, Object[] parameters) {
        this.prepareUpdateCount(sql, updateCount, Arrays.asList(parameters));
    }

    public void prepareUpdateCounts(String sql, int[] updateCounts, Object[] parameters) {
        this.prepareUpdateCounts(sql, updateCounts, Arrays.asList(parameters));
    }

    public void prepareUpdateCount(String sql, int updateCount, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareUpdateCount(sql, updateCount, params);
    }

    public void prepareUpdateCounts(String sql, int[] updateCounts, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareUpdateCounts(sql, updateCounts, params);
    }

    public void prepareUpdateCount(String sql, int updateCount, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.updateCountForStatement);
        list.add(new MockUpdateCountWrapper(updateCount, new HashMap(parameters)));
    }

    public void prepareUpdateCounts(String sql, int[] updateCounts, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.updateCountForStatement);
        list.add(new MockUpdateCountArrayWrapper((int[])updateCounts.clone(), new HashMap(parameters)));
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, Object[] parameters) {
        this.prepareGeneratedKeys(sql, generatedKeysResult, Arrays.asList(parameters));
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, List parameters) {
        Map params = this.createParameterMap(parameters);
        this.prepareGeneratedKeys(sql, generatedKeysResult, params);
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, Map parameters) {
        List list = this.getListFromMapForSQLStatement(sql, this.generatedKeysForStatement);
        list.add(new MockResultSetWrapper(generatedKeysResult, new HashMap(parameters)));
    }

    private List getListFromMapForSQLStatement(String sql, Map map) {
        ArrayList list = (ArrayList)map.get(sql);
        if (null == list) {
            list = new ArrayList();
            map.put(sql, list);
        }
        return list;
    }

    private Map createParameterMap(List parameters) {
        HashMap params = new HashMap();
        for (int ii = 0; ii < parameters.size(); ++ii) {
            params.put(new Integer(ii + 1), parameters.get(ii));
        }
        return params;
    }

    private class MockUpdateCountArrayWrapper
    extends ParameterWrapper {
        private Integer[] updateCounts;

        public MockUpdateCountArrayWrapper(int[] updateCounts, Map parameters) {
            super(parameters);
            this.updateCounts = (Integer[])ArrayUtil.convertToObjectArray((Object)updateCounts);
        }

        public Integer[] getUpdateCount() {
            return this.updateCounts;
        }
    }

    private class MockUpdateCountWrapper
    extends ParameterWrapper {
        private Integer updateCount;

        public MockUpdateCountWrapper(int updateCount, Map parameters) {
            super(parameters);
            this.updateCount = new Integer(updateCount);
        }

        public Integer getUpdateCount() {
            return this.updateCount;
        }
    }

    private class MockResultSetArrayWrapper
    extends ParameterWrapper {
        private MockResultSet[] resultSets;

        public MockResultSetArrayWrapper(MockResultSet[] resultSets, Map parameters) {
            super(parameters);
            this.resultSets = resultSets;
        }

        public MockResultSet[] getResultSets() {
            return this.resultSets;
        }
    }

    private class MockResultSetWrapper
    extends ParameterWrapper {
        private MockResultSet resultSet;

        public MockResultSetWrapper(MockResultSet resultSet, Map parameters) {
            super(parameters);
            this.resultSet = resultSet;
        }

        public MockResultSet getResultSet() {
            return this.resultSet;
        }
    }

    private class MockSQLExceptionWrapper
    extends ParameterWrapper {
        private SQLException exception;

        public MockSQLExceptionWrapper(SQLException exception, Map parameters) {
            super(parameters);
            this.exception = exception;
        }

        public SQLException getException() {
            return this.exception;
        }
    }

    protected class ParameterWrapper {
        private Map parameters;

        public ParameterWrapper(Map parameters) {
            this.parameters = parameters;
        }

        public Map getParamters() {
            return this.parameters;
        }
    }
}

