/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http;

import com.mashape.unirest.http.Headers;
import com.mashape.unirest.http.utils.ResponseUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

public class HttpResponse<T> {
    private int statusCode;
    private String statusText;
    private Headers headers;
    private InputStream rawBody;
    private T body;
    private HttpRequestBase requestObj;
    private InputStream inputStream;
    private Boolean pending;

    public Boolean isPending() {
        return this.pending;
    }

    public HttpResponse(HttpRequestBase requestObj, org.apache.http.HttpResponse response, Class<T> responseClass) {
        this(response, responseClass);
        this.requestObj = requestObj;
    }

    public HttpResponse(org.apache.http.HttpResponse response, Class<T> responseClass) {
        block11: {
            Header[] allHeaders;
            this.headers = new Headers();
            this.pending = false;
            HttpEntity responseEntity = response.getEntity();
            for (Header header : allHeaders = response.getAllHeaders()) {
                String headerName = header.getName().toLowerCase();
                ArrayList<String> list = (ArrayList<String>)this.headers.get(headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                this.headers.put(headerName, list);
            }
            StatusLine statusLine = response.getStatusLine();
            this.statusCode = statusLine.getStatusCode();
            this.statusText = statusLine.getReasonPhrase();
            if (responseEntity != null) {
                String responseCharset;
                String charset = "UTF-8";
                Header contentType = responseEntity.getContentType();
                if (contentType != null && (responseCharset = ResponseUtils.getCharsetFromContentType(contentType.getValue())) != null && !responseCharset.trim().equals("")) {
                    charset = responseCharset;
                }
                try {
                    try {
                        InputStream responseInputStream = responseEntity.getContent();
                        if (ResponseUtils.isGzipped(responseEntity.getContentEncoding())) {
                            responseInputStream = new GZIPInputStream(responseEntity.getContent());
                        }
                        this.inputStream = responseInputStream;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    this.pending = true;
                    if (String.class.equals(responseClass)) {
                        byte[] rawBody = ResponseUtils.getBytes(this.inputStream);
                        this.rawBody = new ByteArrayInputStream(rawBody);
                        this.body = new String(rawBody, charset);
                        EntityUtils.consume((HttpEntity)responseEntity);
                        this.inputStream.close();
                        this.close();
                        break block11;
                    }
                    if (InputStream.class.equals(responseClass)) {
                        this.rawBody = this.inputStream;
                        this.body = this.rawBody;
                        break block11;
                    }
                    throw new Exception("Unknown result type. Only String, JsonNode and InputStream are supported.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public T getBody() {
        return this.body;
    }

    public HttpRequestBase getBaseRequest() {
        return this.requestObj;
    }

    public void close() {
        if (this.pending.booleanValue()) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.requestObj != null) {
                    this.requestObj.releaseConnection();
                }
                this.pending = false;
            }
        }
    }
}

