/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.BitFieldCommand;
import com.moilioncircle.redis.replicator.cmd.impl.GetTypeOffset;
import com.moilioncircle.redis.replicator.cmd.impl.IncrByTypeOffsetIncrement;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlow;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlowType;
import com.moilioncircle.redis.replicator.cmd.impl.SetTypeOffsetValue;
import com.moilioncircle.redis.replicator.cmd.impl.Statement;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;
import java.util.List;

public class BitFieldParser
implements CommandParser<BitFieldCommand> {
    @Override
    public BitFieldCommand parse(Object[] command) {
        int idx = 1;
        String key = CommandParsers.toRune(command[idx]);
        byte[] rawKey = CommandParsers.toBytes(command[idx]);
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (++idx < command.length) {
            String token;
            while ((idx = this.parseStatement(idx, command, list)) < command.length && (token = CommandParsers.toRune(command[idx])) != null && (Strings.isEquals(token, "GET") || Strings.isEquals(token, "SET") || Strings.isEquals(token, "INCRBY"))) {
            }
        }
        ArrayList<OverFlow> overflows = null;
        if (idx < command.length) {
            overflows = new ArrayList<OverFlow>();
            do {
                OverFlow overFlow = new OverFlow();
                idx = this.parseOverFlow(idx, command, overFlow);
                overflows.add(overFlow);
            } while (idx < command.length && Strings.isEquals(CommandParsers.toRune(command[idx]), "OVERFLOW"));
        }
        return new BitFieldCommand(key, list, overflows, rawKey);
    }

    private int parseOverFlow(int i, Object[] params, OverFlow overFlow) {
        OverFlowType overflow;
        int idx = i;
        this.accept(CommandParsers.toRune(params[idx++]), "OVERFLOW");
        String keyword = CommandParsers.toRune(params[idx++]);
        if (Strings.isEquals(keyword, "WRAP")) {
            overflow = OverFlowType.WRAP;
        } else if (Strings.isEquals(keyword, "SAT")) {
            overflow = OverFlowType.SAT;
        } else if (Strings.isEquals(keyword, "FAIL")) {
            overflow = OverFlowType.FAIL;
        } else {
            throw new AssertionError((Object)("parse [BITFIELD] command error." + keyword));
        }
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (idx < params.length) {
            String token;
            while ((idx = this.parseStatement(idx, params, list)) < params.length && (token = CommandParsers.toRune(params[idx])) != null && (Strings.isEquals(token, "GET") || Strings.isEquals(token, "SET") || Strings.isEquals(token, "INCRBY"))) {
            }
        }
        overFlow.setOverFlowType(overflow);
        overFlow.setStatements(list);
        return idx;
    }

    private int parseStatement(int i, Object[] params, List<Statement> list) {
        Statement statement;
        String keyword;
        int idx = i;
        if (Strings.isEquals(keyword = CommandParsers.toRune(params[idx++]), "GET")) {
            GetTypeOffset getTypeOffset = new GetTypeOffset();
            idx = this.parseGet(idx - 1, params, getTypeOffset);
            statement = getTypeOffset;
        } else if (Strings.isEquals(keyword, "SET")) {
            SetTypeOffsetValue setTypeOffsetValue = new SetTypeOffsetValue();
            idx = this.parseSet(idx - 1, params, setTypeOffsetValue);
            statement = setTypeOffsetValue;
        } else if (Strings.isEquals(keyword, "INCRBY")) {
            IncrByTypeOffsetIncrement incrByTypeOffsetIncrement = new IncrByTypeOffsetIncrement();
            idx = this.parseIncrBy(idx - 1, params, incrByTypeOffsetIncrement);
            statement = incrByTypeOffsetIncrement;
        } else {
            return i;
        }
        list.add(statement);
        return idx;
    }

    private int parseIncrBy(int i, Object[] params, IncrByTypeOffsetIncrement incrByTypeOffsetIncrement) {
        int idx = i;
        this.accept(CommandParsers.toRune(params[idx++]), "INCRBY");
        String type = CommandParsers.toRune(params[idx]);
        byte[] rawType = CommandParsers.toBytes(params[idx]);
        String offset = CommandParsers.toRune(params[++idx]);
        byte[] rawOffset = CommandParsers.toBytes(params[idx]);
        int n = ++idx;
        ++idx;
        long increment = CommandParsers.toLong(params[n]);
        incrByTypeOffsetIncrement.setType(type);
        incrByTypeOffsetIncrement.setOffset(offset);
        incrByTypeOffsetIncrement.setIncrement(increment);
        incrByTypeOffsetIncrement.setRawType(rawType);
        incrByTypeOffsetIncrement.setRawOffset(rawOffset);
        return idx;
    }

    private int parseSet(int i, Object[] params, SetTypeOffsetValue setTypeOffsetValue) {
        int idx = i;
        this.accept(CommandParsers.toRune(params[idx++]), "SET");
        String type = CommandParsers.toRune(params[idx]);
        byte[] rawType = CommandParsers.toBytes(params[idx]);
        String offset = CommandParsers.toRune(params[++idx]);
        byte[] rawOffset = CommandParsers.toBytes(params[idx]);
        int n = ++idx;
        ++idx;
        long value = CommandParsers.toLong(params[n]);
        setTypeOffsetValue.setType(type);
        setTypeOffsetValue.setOffset(offset);
        setTypeOffsetValue.setValue(value);
        setTypeOffsetValue.setRawType(rawType);
        setTypeOffsetValue.setRawOffset(rawOffset);
        return idx;
    }

    private int parseGet(int i, Object[] params, GetTypeOffset getTypeOffset) {
        int idx = i;
        this.accept(CommandParsers.toRune(params[idx++]), "GET");
        String type = CommandParsers.toRune(params[idx]);
        byte[] rawType = CommandParsers.toBytes(params[idx]);
        String offset = CommandParsers.toRune(params[++idx]);
        byte[] rawOffset = CommandParsers.toBytes(params[idx]);
        getTypeOffset.setType(type);
        getTypeOffset.setOffset(offset);
        getTypeOffset.setRawType(rawType);
        getTypeOffset.setRawOffset(rawOffset);
        return ++idx;
    }

    private void accept(String actual, String expect) {
        if (Strings.isEquals(actual, expect)) {
            return;
        }
        throw new AssertionError((Object)("expect " + expect + " but actual " + actual));
    }
}

