/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.RestoreCommand;
import com.moilioncircle.redis.replicator.rdb.datatype.EvictType;
import com.moilioncircle.redis.replicator.util.Strings;

public class RestoreParser
implements CommandParser<RestoreCommand> {
    @Override
    public RestoreCommand parse(Object[] command) {
        int idx = 1;
        String key = CommandParsers.toRune(command[idx]);
        byte[] rawKey = CommandParsers.toBytes(command[idx]);
        int n = ++idx;
        long ttl = CommandParsers.toLong(command[n]);
        String serializedValue = CommandParsers.toRune(command[++idx]);
        byte[] rawSerializedValue = CommandParsers.toBytes(command[idx]);
        ++idx;
        Boolean isReplace = null;
        Boolean absTtl = null;
        EvictType evictType = EvictType.NONE;
        Long evictValue = null;
        while (idx < command.length) {
            if (Strings.isEquals(CommandParsers.toRune(command[idx]), "REPLACE")) {
                isReplace = true;
            } else if (Strings.isEquals(CommandParsers.toRune(command[idx]), "ABSTTL")) {
                absTtl = true;
            } else if (Strings.isEquals(CommandParsers.toRune(command[idx]), "IDLETIME")) {
                evictType = EvictType.LRU;
                evictValue = CommandParsers.toLong(command[++idx]);
            } else if (Strings.isEquals(CommandParsers.toRune(command[idx]), "FREQ")) {
                evictType = EvictType.LFU;
                evictValue = CommandParsers.toLong(command[++idx]);
            } else {
                throw new UnsupportedOperationException(CommandParsers.toRune(command[idx]));
            }
            ++idx;
        }
        return new RestoreCommand(key, ttl, serializedValue, isReplace, absTtl, evictType, evictValue, rawKey, rawSerializedValue);
    }
}

