/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import com.moilioncircle.redis.replicator.util.CRC64;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.util.NoSuchElementException;

public class DumpRdbVisitor
extends DefaultRdbVisitor {
    private final int size;
    private final int version;

    public DumpRdbVisitor(Replicator replicator) {
        this(replicator, -1);
    }

    public DumpRdbVisitor(Replicator replicator, int version) {
        this(replicator, version, 8192);
    }

    public DumpRdbVisitor(Replicator replicator, int version, int size) {
        super(replicator);
        this.version = version;
        this.size = size;
    }

    @Override
    public Event applyString(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o0 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(0, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadEncodedStringObject();
        this.replicator.removeRawByteListener(listener);
        o0.setValueRdbType(0);
        o0.setValue(listener.getBytes());
        o0.setDb(db);
        o0.setKey(Strings.toString(key));
        o0.setRawKey(key);
        return o0;
    }

    @Override
    public Event applyList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o1 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        o1.setValueRdbType(1);
        o1.setValue(listener.getBytes());
        o1.setDb(db);
        o1.setKey(Strings.toString(key));
        o1.setRawKey(key);
        return o1;
    }

    @Override
    public Event applySet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o2 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(2, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        o2.setValueRdbType(2);
        o2.setValue(listener.getBytes());
        o2.setDb(db);
        o2.setKey(Strings.toString(key));
        o2.setRawKey(key);
        return o2;
    }

    @Override
    public Event applyZSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o3 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        o3.setValueRdbType(3);
        o3.setValue(listener.getBytes());
        o3.setDb(db);
        o3.setKey(Strings.toString(key));
        o3.setRawKey(key);
        return o3;
    }

    @Override
    public Event applyZSet2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o5 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(5, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadBinaryDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        o5.setValueRdbType(5);
        o5.setValue(listener.getBytes());
        o5.setDb(db);
        o5.setKey(Strings.toString(key));
        o5.setRawKey(key);
        return o5;
    }

    @Override
    public Event applyHash(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o4 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(4, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        o4.setValueRdbType(4);
        o4.setValue(listener.getBytes());
        o4.setDb(db);
        o4.setKey(Strings.toString(key));
        o4.setRawKey(key);
        return o4;
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o9 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(9, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o9.setValueRdbType(9);
        o9.setValue(listener.getBytes());
        o9.setDb(db);
        o9.setKey(Strings.toString(key));
        o9.setRawKey(key);
        return o9;
    }

    @Override
    public Event applyListZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o10 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(10, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o10.setValueRdbType(10);
        o10.setValue(listener.getBytes());
        o10.setDb(db);
        o10.setKey(Strings.toString(key));
        o10.setRawKey(key);
        return o10;
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o11 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(11, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o11.setValueRdbType(11);
        o11.setValue(listener.getBytes());
        o11.setDb(db);
        o11.setKey(Strings.toString(key));
        o11.setRawKey(key);
        return o11;
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o12 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(12, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o12.setValueRdbType(12);
        o12.setValue(listener.getBytes());
        o12.setDb(db);
        o12.setKey(Strings.toString(key));
        o12.setRawKey(key);
        return o12;
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o13 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(13, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o13.setValueRdbType(13);
        o13.setValue(listener.getBytes());
        o13.setDb(db);
        o13.setKey(Strings.toString(key));
        o13.setRawKey(key);
        return o13;
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o14 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(14, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long len = skipParser.rdbLoadLen().len;
        for (long i = 0L; i < len; ++i) {
            skipParser.rdbGenericLoadStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        o14.setValueRdbType(14);
        o14.setValue(listener.getBytes());
        o14.setDb(db);
        o14.setKey(Strings.toString(key));
        o14.setRawKey(key);
        return o14;
    }

    @Override
    public Event applyModule(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o6 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(6, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        moduleParser.parse(in, 1);
        this.replicator.removeRawByteListener(listener);
        o6.setValueRdbType(6);
        o6.setValue(listener.getBytes());
        o6.setDb(db);
        o6.setKey(Strings.toString(key));
        o6.setRawKey(key);
        return o6;
    }

    @Override
    public Event applyModule2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o7 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(7, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            SkipRdbParser skipRdbParser = new SkipRdbParser(in);
            skipRdbParser.rdbLoadCheckModuleValue();
        } else {
            moduleParser.parse(in, 2);
            long eof = parser.rdbLoadLen().len;
            if (eof != 0L) {
                throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
            }
        }
        this.replicator.removeRawByteListener(listener);
        o7.setValueRdbType(7);
        o7.setValue(listener.getBytes());
        o7.setDb(db);
        o7.setKey(Strings.toString(key));
        o7.setRawKey(key);
        return o7;
    }

    @Override
    public Event applyStreamListPacks(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o15 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(15, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long listPacks = skipParser.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            skipParser.rdbLoadPlainStringObject();
            skipParser.rdbLoadPlainStringObject();
        }
        skipParser.rdbLoadLen();
        skipParser.rdbLoadLen();
        skipParser.rdbLoadLen();
        long groupCount = skipParser.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            skipParser.rdbLoadPlainStringObject();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            long groupPel = skipParser.rdbLoadLen().len;
            while (groupPel-- > 0L) {
                in.skip(16L);
                skipParser.rdbLoadMillisecondTime();
                skipParser.rdbLoadLen();
            }
            long consumerCount = skipParser.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadMillisecondTime();
                long consumerPel = skipParser.rdbLoadLen().len;
                while (consumerPel-- > 0L) {
                    in.skip(16L);
                }
            }
        }
        this.replicator.removeRawByteListener(listener);
        o15.setValueRdbType(15);
        o15.setValue(listener.getBytes());
        o15.setDb(db);
        o15.setKey(Strings.toString(key));
        o15.setRawKey(key);
        return o15;
    }

    private class DefaultRawByteListener
    implements RawByteListener {
        private final int version;
        private final ByteBuilder builder;

        private DefaultRawByteListener(byte type, int version) {
            this.builder = ByteBuilder.allocate(DumpRdbVisitor.this.size);
            this.builder.put(type);
            int ver = DumpRdbVisitor.this.version;
            this.version = ver == -1 ? version : ver;
        }

        @Override
        public void handle(byte ... rawBytes) {
            for (byte b : rawBytes) {
                this.builder.put(b);
            }
        }

        public byte[] getBytes() {
            byte[] crc;
            this.builder.put((byte)this.version);
            this.builder.put((byte)0);
            byte[] bytes = this.builder.array();
            for (byte b : crc = CRC64.longToByteArray(CRC64.crc64(bytes))) {
                this.builder.put(b);
            }
            return this.builder.array();
        }
    }
}

