/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XClaimCommand;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;
import java.util.Objects;

public class XClaimParser
implements CommandParser<XClaimCommand> {
    @Override
    public XClaimCommand parse(Object[] command) {
        byte[] id;
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        byte[] group = CommandParsers.toBytes(command[++idx]);
        byte[] consumer = CommandParsers.toBytes(command[++idx]);
        int n = ++idx;
        ++idx;
        long minIdle = CommandParsers.toLong(command[n]);
        ArrayList<byte[]> ids = new ArrayList<byte[]>();
        while (idx < command.length && this.validId(id = CommandParsers.toBytes(command[idx]))) {
            ids.add(id);
            ++idx;
        }
        Long idle = null;
        Long time = null;
        Long retryCount = null;
        boolean force = false;
        boolean justId = false;
        while (idx < command.length) {
            String next = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(next, "IDLE")) {
                idle = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "TIME")) {
                time = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "RETRYCOUNT")) {
                retryCount = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "FORCE")) {
                ++idx;
                force = true;
                continue;
            }
            if (Strings.isEquals(next, "JUSTID")) {
                ++idx;
                justId = true;
                continue;
            }
            throw new UnsupportedOperationException(next);
        }
        return new XClaimCommand(key, group, consumer, minIdle, (byte[][])ids.toArray((T[])new byte[0][]), idle, time, retryCount, force, justId);
    }

    private boolean validId(byte[] bid) {
        if (bid == null) {
            return false;
        }
        String id = CommandParsers.toRune(bid);
        if (Objects.equals(id, "+") || Objects.equals(id, "-")) {
            return true;
        }
        int idx = id.indexOf(45);
        try {
            Long.parseLong(id.substring(0, idx));
            Long.parseLong(id.substring(idx + 1, id.length()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

