/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.iterable;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.UncheckedIOException;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ContextKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueByteArrayIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueMapEntryIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueZSetEntryIterator;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;

public class ValueIterableRdbVisitor
extends DefaultRdbVisitor {
    public ValueIterableRdbVisitor(Replicator replicator) {
        super(replicator);
    }

    @Override
    public Event applyList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o1 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o1.setValue(new Iter<byte[]>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return element;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o1.setValueRdbType(1);
        o1.setKey(key);
        return context.valueOf(o1);
    }

    @Override
    public Event applySet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o2 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o2.setValue(new Iter<byte[]>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return element;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o2.setValueRdbType(2);
        o2.setKey(key);
        return context.valueOf(o2);
    }

    @Override
    public Event applyZSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o3 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o3.setValue(new Iter<ZSetEntry>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    double score = this.parser.rdbLoadDoubleValue();
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o3.setValueRdbType(3);
        o3.setKey(key);
        return context.valueOf(o3);
    }

    @Override
    public Event applyZSet2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o5 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o5.setValue(new Iter<ZSetEntry>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    double score = this.parser.rdbLoadBinaryDoubleValue();
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o5.setValueRdbType(5);
        o5.setKey(key);
        return context.valueOf(o5);
    }

    @Override
    public Event applyHash(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o4 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o4.setValue(new Iter<Map.Entry<byte[], byte[]>>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                try {
                    byte[] field = this.parser.rdbLoadEncodedStringObject().first();
                    byte[] value = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o4.setValueRdbType(4);
        o4.setKey(key);
        return context.valueOf(o4);
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o9 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zmlen(stream);
        o9.setValue(new HashZipMapIter(stream));
        o9.setValueRdbType(9);
        o9.setKey(key);
        return context.valueOf(o9);
    }

    @Override
    public Event applyListZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o10 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        o10.setValue(new Iter<byte[]>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public byte[] next() {
                try {
                    byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    return e;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o10.setValueRdbType(10);
        o10.setKey(key);
        return context.valueOf(o10);
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o11 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        final int encoding = BaseRdbParser.LenHelper.encoding(stream);
        long lenOfContent = BaseRdbParser.LenHelper.lenOfContent(stream);
        o11.setValue(new Iter<byte[]>(lenOfContent, null){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    switch (encoding) {
                        case 2: {
                            String element = String.valueOf(stream.readInt(2));
                            --this.condition;
                            return element.getBytes();
                        }
                        case 4: {
                            String element = String.valueOf(stream.readInt(4));
                            --this.condition;
                            return element.getBytes();
                        }
                        case 8: {
                            String element = String.valueOf(stream.readLong(8));
                            --this.condition;
                            return element.getBytes();
                        }
                    }
                    throw new AssertionError((Object)("expect encoding [2,4,8] but:" + encoding));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o11.setValueRdbType(11);
        o11.setKey(key);
        return context.valueOf(o11);
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o12 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        o12.setValue(new Iter<ZSetEntry>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.zipListEntry(stream)));
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o12.setValueRdbType(12);
        o12.setKey(key);
        return context.valueOf(o12);
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o13 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        o13.setValue(new Iter<Map.Entry<byte[], byte[]>>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                try {
                    byte[] field = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    byte[] value = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        o13.setValueRdbType(13);
        o13.setKey(key);
        return context.valueOf(o13);
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o14 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        o14.setValue(new QuickListIter(len, parser));
        o14.setValueRdbType(14);
        o14.setKey(key);
        return context.valueOf(o14);
    }

    private static class QuickListIter
    extends Iter<byte[]> {
        protected int zllen = -1;
        protected RedisInputStream stream;

        private QuickListIter(long condition, BaseRdbParser parser) {
            super(condition, parser);
        }

        @Override
        public boolean hasNext() {
            return this.zllen > 0 || this.condition > 0L;
        }

        @Override
        public byte[] next() {
            try {
                if (this.zllen == -1 && this.condition > 0L) {
                    this.stream = new RedisInputStream(this.parser.rdbGenericLoadStringObject(0));
                    BaseRdbParser.LenHelper.zlbytes(this.stream);
                    BaseRdbParser.LenHelper.zltail(this.stream);
                    this.zllen = BaseRdbParser.LenHelper.zllen(this.stream);
                    if (this.zllen == 0) {
                        int zlend = BaseRdbParser.LenHelper.zlend(this.stream);
                        if (zlend != 255) {
                            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                        }
                        this.zllen = -1;
                        --this.condition;
                    }
                    if (this.hasNext()) {
                        return this.next();
                    }
                    throw new IllegalStateException("end of iterator");
                }
                byte[] e = BaseRdbParser.StringHelper.zipListEntry(this.stream);
                --this.zllen;
                if (this.zllen == 0) {
                    int zlend = BaseRdbParser.LenHelper.zlend(this.stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    this.zllen = -1;
                    --this.condition;
                }
                return e;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class HashZipMapIter
    extends Iter<Map.Entry<byte[], byte[]>> {
        protected int zmEleLen;
        protected final RedisInputStream stream;

        private HashZipMapIter(RedisInputStream stream) {
            super(0L, null);
            this.stream = stream;
        }

        @Override
        public boolean hasNext() {
            try {
                this.zmEleLen = BaseRdbParser.LenHelper.zmElementLen(this.stream);
                return this.zmEleLen != 255;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            try {
                byte[] field = BaseRdbParser.StringHelper.bytes(this.stream, this.zmEleLen);
                this.zmEleLen = BaseRdbParser.LenHelper.zmElementLen(this.stream);
                if (this.zmEleLen == 255) {
                    return new AbstractMap.SimpleEntry<byte[], Object>(field, null);
                }
                int free = BaseRdbParser.LenHelper.free(this.stream);
                byte[] value = BaseRdbParser.StringHelper.bytes(this.stream, this.zmEleLen);
                BaseRdbParser.StringHelper.skip(this.stream, free);
                return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static abstract class Iter<T>
    implements Iterator<T> {
        protected long condition;
        protected final BaseRdbParser parser;

        private Iter(long condition, BaseRdbParser parser) {
            this.condition = condition;
            this.parser = parser;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

