/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import org.apache.commons.lang3.StringUtils;

public class CommandSetterBuilder {
    private String groupKey;
    private String commandKey;
    private String threadPoolKey;

    public CommandSetterBuilder groupKey(String pGroupKey) {
        this.groupKey = pGroupKey;
        return this;
    }

    public CommandSetterBuilder groupKey(String pGroupKey, String def) {
        this.groupKey = StringUtils.isNotEmpty((CharSequence)pGroupKey) ? pGroupKey : def;
        return this;
    }

    public CommandSetterBuilder commandKey(String pCommandKey) {
        this.commandKey = pCommandKey;
        return this;
    }

    public CommandSetterBuilder commandKey(String pCommandKey, String def) {
        this.commandKey = StringUtils.isNotEmpty((CharSequence)pCommandKey) ? pCommandKey : def;
        return this;
    }

    public CommandSetterBuilder threadPoolKey(String pThreadPoolKey) {
        this.threadPoolKey = pThreadPoolKey;
        return this;
    }

    public HystrixCommand.Setter build() {
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)this.groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)this.commandKey));
        if (StringUtils.isNotBlank((CharSequence)this.threadPoolKey)) {
            setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)this.threadPoolKey));
        }
        return setter;
    }
}

