/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import java.util.Collection;

public class LazyCommandExecutionAction
extends CommandAction {
    private MetaHolder metaHolder;
    private Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests;
    private HystrixCommandFactory<?> commandFactory;

    public LazyCommandExecutionAction(HystrixCommandFactory<?> commandFactory, MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        this.commandFactory = commandFactory;
        this.metaHolder = metaHolder;
        this.collapsedRequests = collapsedRequests;
    }

    @Override
    public Object execute(ExecutionType executionType) {
        Object abstractHystrixCommand = this.commandFactory.create(this.createHolder(executionType), this.collapsedRequests);
        return new CommandExecutionAction((AbstractHystrixCommand)((Object)abstractHystrixCommand)).execute(executionType);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) {
        Object abstractHystrixCommand = this.commandFactory.create(this.createHolder(executionType, args), this.collapsedRequests);
        return new CommandExecutionAction((AbstractHystrixCommand)((Object)abstractHystrixCommand)).execute(executionType);
    }

    private MetaHolder createHolder(ExecutionType executionType) {
        return MetaHolder.builder().obj(this.metaHolder.getObj()).method(this.metaHolder.getMethod()).executionType(executionType).args(this.metaHolder.getArgs()).defaultCollapserKey(this.metaHolder.getDefaultCollapserKey()).defaultCommandKey(this.metaHolder.getDefaultCommandKey()).defaultGroupKey(this.metaHolder.getDefaultGroupKey()).hystrixCollapser(this.metaHolder.getHystrixCollapser()).hystrixCommand(this.metaHolder.getHystrixCommand()).build();
    }

    private MetaHolder createHolder(ExecutionType executionType, Object[] args) {
        return MetaHolder.builder().obj(this.metaHolder.getObj()).method(this.metaHolder.getMethod()).executionType(executionType).args(args).defaultCollapserKey(this.metaHolder.getDefaultCollapserKey()).defaultCommandKey(this.metaHolder.getDefaultCommandKey()).defaultGroupKey(this.metaHolder.getDefaultGroupKey()).hystrixCollapser(this.metaHolder.getHystrixCollapser()).hystrixCommand(this.metaHolder.getHystrixCommand()).build();
    }
}

