/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.base.Throwables;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.closure.Closure;
import com.netflix.hystrix.contrib.javanica.command.closure.ClosureFactoryRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodExecutionAction
extends CommandAction {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Object object;
    private final Method method;
    private final Object[] _args;

    public MethodExecutionAction(Object object, Method method) {
        this.object = object;
        this.method = method;
        this._args = EMPTY_ARGS;
    }

    public MethodExecutionAction(Object object, Method method, Object[] args) {
        this.object = object;
        this.method = method;
        this._args = args;
    }

    public Object getObject() {
        return this.object;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this._args;
    }

    @Override
    public Object execute(ExecutionType executionType) {
        return this.executeWithArgs(executionType, this._args);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) {
        if (ExecutionType.SYNCHRONOUS.equals((Object)executionType)) {
            return this.execute(this.object, this.method, args);
        }
        Closure closure = ClosureFactoryRegistry.getFactory(executionType).createClosure(this.method, this.object, args);
        return this.execute(closure.getClosureObj(), closure.getClosureMethod(), new Object[0]);
    }

    private Object execute(Object o, Method m, Object ... args) {
        Object result = null;
        try {
            m.setAccessible(true);
            result = m.invoke(o, args);
        }
        catch (IllegalAccessException e) {
            this.propagateCause(e);
        }
        catch (InvocationTargetException e) {
            this.propagateCause(e);
        }
        return result;
    }

    private void propagateCause(Throwable throwable) {
        throw Throwables.propagate((Throwable)throwable.getCause());
    }
}

