/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContextFactory;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.CommandSetterBuilder;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericHystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.LazyCommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.utils.EnvUtils;
import com.netflix.hystrix.contrib.javanica.utils.FallbackMethod;
import com.netflix.hystrix.contrib.javanica.utils.MethodProvider;
import com.netflix.hystrix.contrib.javanica.utils.ajc.AjcUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractHystrixCommandFactory<T extends AbstractHystrixCommand>
implements HystrixCommandFactory<T> {
    @Override
    public T create(MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        Validate.notNull((Object)metaHolder.getHystrixCommand(), (String)"hystrixCommand cannot be null", (Object[])new Object[0]);
        String groupKey = StringUtils.isNotEmpty((CharSequence)metaHolder.getHystrixCommand().groupKey()) ? metaHolder.getHystrixCommand().groupKey() : metaHolder.getDefaultGroupKey();
        String commandKey = StringUtils.isNotEmpty((CharSequence)metaHolder.getHystrixCommand().commandKey()) ? metaHolder.getHystrixCommand().commandKey() : metaHolder.getDefaultCommandKey();
        CommandSetterBuilder setterBuilder = new CommandSetterBuilder();
        setterBuilder.commandKey(commandKey);
        setterBuilder.groupKey(groupKey);
        setterBuilder.threadPoolKey(metaHolder.getHystrixCommand().threadPoolKey());
        setterBuilder.threadPoolProperties(metaHolder.getHystrixCommand().threadPoolProperties());
        setterBuilder.commandProperties(metaHolder.getHystrixCommand().commandProperties());
        Map<String, Object> commandProperties = this.getCommandProperties(metaHolder.getHystrixCommand());
        MethodExecutionAction commandAction = new MethodExecutionAction(metaHolder.getObj(), metaHolder.getMethod(), metaHolder.getArgs(), metaHolder);
        CommandAction fallbackAction = this.createFallbackAction(metaHolder, collapsedRequests);
        CommandActions commandActions = CommandActions.builder().commandAction(commandAction).fallbackAction(fallbackAction).build();
        HystrixCommandBuilder hystrixCommandBuilder = new HystrixCommandBuilder().setterBuilder(setterBuilder).commandActions(commandActions).commandProperties(commandProperties).collapsedRequests(collapsedRequests).cacheResultInvocationContext(CacheInvocationContextFactory.createCacheResultInvocationContext(metaHolder)).cacheRemoveInvocationContext(CacheInvocationContextFactory.createCacheRemoveInvocationContext(metaHolder)).ignoreExceptions(metaHolder.getHystrixCommand().ignoreExceptions()).executionType(metaHolder.getExecutionType());
        return this.create(hystrixCommandBuilder);
    }

    CommandAction createFallbackAction(MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        FallbackMethod fallbackMethod = MethodProvider.getInstance().getFallbackMethod(metaHolder.getObj().getClass(), metaHolder.getMethod(), metaHolder.isExtendedFallback());
        fallbackMethod.validateReturnType(metaHolder.getMethod());
        CommandAction fallbackAction = null;
        if (fallbackMethod.isPresent()) {
            Method fMethod = fallbackMethod.getMethod();
            if (fallbackMethod.isCommand()) {
                fMethod.setAccessible(true);
                MetaHolder fmMetaHolder = MetaHolder.builder().obj(metaHolder.getObj()).method(fMethod).ajcMethod(this.getAjcMethod(metaHolder.getObj(), fMethod)).args(metaHolder.getArgs()).fallback(true).defaultCollapserKey(metaHolder.getDefaultCollapserKey()).fallbackMethod(fMethod).extendedFallback(fallbackMethod.isExtended()).fallbackExecutionType(fallbackMethod.getExecutionType()).extendedParentFallback(metaHolder.isExtendedFallback()).defaultCommandKey(fMethod.getName()).defaultGroupKey(metaHolder.getDefaultGroupKey()).hystrixCollapser(metaHolder.getHystrixCollapser()).hystrixCommand(fMethod.getAnnotation(HystrixCommand.class)).build();
                fallbackAction = new LazyCommandExecutionAction(GenericHystrixCommandFactory.getInstance(), fmMetaHolder, collapsedRequests);
            } else {
                MetaHolder fmMetaHolder = MetaHolder.builder().obj(metaHolder.getObj()).method(fMethod).fallbackExecutionType(ExecutionType.SYNCHRONOUS).extendedFallback(fallbackMethod.isExtended()).extendedParentFallback(metaHolder.isExtendedFallback()).ajcMethod(null).args(metaHolder.getArgs()).build();
                fallbackAction = new MethodExecutionAction(fmMetaHolder.getObj(), fMethod, fmMetaHolder.getArgs(), fmMetaHolder);
            }
        }
        return fallbackAction;
    }

    abstract T create(HystrixCommandBuilder var1);

    private Method getAjcMethod(Object target, Method fallback) {
        if (EnvUtils.isCompileWeaving()) {
            return AjcUtils.getAjcMethodAroundAdvice(target.getClass(), fallback);
        }
        return null;
    }

    private CommandAction createCacheKeyAction(MetaHolder metaHolder) {
        MethodExecutionAction cacheKeyAction = null;
        if (metaHolder.getCacheKeyMethod() != null) {
            cacheKeyAction = new MethodExecutionAction(metaHolder.getObj(), metaHolder.getCacheKeyMethod(), metaHolder.getArgs(), metaHolder);
        }
        return cacheKeyAction;
    }

    private Map<String, Object> getCommandProperties(HystrixCommand hystrixCommand) {
        if (hystrixCommand.commandProperties() == null || hystrixCommand.commandProperties().length == 0) {
            return Collections.emptyMap();
        }
        HashMap commandProperties = Maps.newHashMap();
        for (HystrixProperty commandProperty : hystrixCommand.commandProperties()) {
            commandProperties.put(commandProperty.name(), commandProperty.value());
        }
        return commandProperties;
    }
}

