/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import com.netflix.hystrix.contrib.javanica.exception.HystrixPropertyException;
import org.apache.commons.lang3.StringUtils;

public class CommandSetterBuilder {
    private String groupKey;
    private String commandKey;
    private String threadPoolKey;
    private HystrixProperty[] commandProperties = EMPTY;
    private HystrixProperty[] threadPoolProperties = EMPTY;
    private static final HystrixProperty[] EMPTY = new HystrixProperty[0];

    public CommandSetterBuilder groupKey(String pGroupKey) {
        this.groupKey = pGroupKey;
        return this;
    }

    public CommandSetterBuilder groupKey(String pGroupKey, String def) {
        this.groupKey = StringUtils.isNotEmpty((CharSequence)pGroupKey) ? pGroupKey : def;
        return this;
    }

    public CommandSetterBuilder commandKey(String pCommandKey) {
        this.commandKey = pCommandKey;
        return this;
    }

    public CommandSetterBuilder commandKey(String pCommandKey, String def) {
        this.commandKey = StringUtils.isNotEmpty((CharSequence)pCommandKey) ? pCommandKey : def;
        return this;
    }

    public CommandSetterBuilder commandProperties(HystrixProperty[] properties) {
        this.commandProperties = properties;
        return this;
    }

    public CommandSetterBuilder threadPoolProperties(HystrixProperty[] properties) {
        this.threadPoolProperties = properties;
        return this;
    }

    public CommandSetterBuilder threadPoolKey(String pThreadPoolKey) {
        this.threadPoolKey = pThreadPoolKey;
        return this;
    }

    public HystrixCommand.Setter build() throws HystrixPropertyException {
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)this.groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)this.commandKey));
        if (StringUtils.isNotBlank((CharSequence)this.threadPoolKey)) {
            setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)this.threadPoolKey));
        }
        try {
            setter.andThreadPoolPropertiesDefaults(HystrixPropertiesManager.initializeThreadPoolProperties(this.threadPoolProperties));
        }
        catch (IllegalArgumentException e) {
            throw new HystrixPropertyException("Failed to set Thread Pool properties. " + this.getInfo(), e);
        }
        try {
            setter.andCommandPropertiesDefaults(HystrixPropertiesManager.initializeCommandProperties(this.commandProperties));
        }
        catch (IllegalArgumentException e) {
            throw new HystrixPropertyException("Failed to set Command properties. " + this.getInfo(), e);
        }
        return setter;
    }

    private String getInfo() {
        return "groupKey: '" + this.groupKey + "', commandKey: '" + this.commandKey + "', threadPoolKey: '" + this.threadPoolKey + "'";
    }
}

