/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.conf;

import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class HystrixPropertiesManager {
    public static final String EXECUTION_ISOLATION_STRATEGY = "execution.isolation.strategy";
    public static final String EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS = "execution.isolation.thread.timeoutInMilliseconds";
    public static final String EXECUTION_TIMEOUT_ENABLED = "execution.timeout.enabled";
    public static final String EXECUTION_ISOLATION_THREAD_INTERRUPT_ON_TIMEOUT = "execution.isolation.thread.interruptOnTimeout";
    public static final String EXECUTION_ISOLATION_SEMAPHORE_MAX_CONCURRENT_REQUESTS = "execution.isolation.semaphore.maxConcurrentRequests";
    public static final String FALLBACK_ISOLATION_SEMAPHORE_MAX_CONCURRENT_REQUESTS = "fallback.isolation.semaphore.maxConcurrentRequests";
    public static final String FALLBACK_ENABLED = "fallback.enabled";
    public static final String CIRCUIT_BREAKER_ENABLED = "circuitBreaker.enabled";
    public static final String CIRCUIT_BREAKER_REQUEST_VOLUME_THRESHOLD = "circuitBreaker.requestVolumeThreshold";
    public static final String CIRCUIT_BREAKER_SLEEP_WINDOW_IN_MILLISECONDS = "circuitBreaker.sleepWindowInMilliseconds";
    public static final String CIRCUIT_BREAKER_ERROR_THRESHOLD_PERCENTAGE = "circuitBreaker.errorThresholdPercentage";
    public static final String CIRCUIT_BREAKER_FORCE_OPEN = "circuitBreaker.forceOpen";
    public static final String CIRCUIT_BREAKER_FORCE_CLOSED = "circuitBreaker.forceClosed";
    public static final String METRICS_ROLLING_PERCENTILE_ENABLED = "metrics.rollingPercentile.enabled";
    public static final String METRICS_ROLLING_PERCENTILE_TIME_IN_MILLISECONDS = "metrics.rollingPercentile.timeInMilliseconds";
    public static final String METRICS_ROLLING_PERCENTILE_NUM_BUCKETS = "metrics.rollingPercentile.numBuckets";
    public static final String METRICS_ROLLING_PERCENTILE_BUCKET_SIZE = "metrics.rollingPercentile.bucketSize";
    public static final String METRICS_HEALTH_SNAPSHOT_INTERVAL_IN_MILLISECONDS = "metrics.healthSnapshot.intervalInMilliseconds";
    public static final String REQUEST_CACHE_ENABLED = "requestCache.enabled";
    public static final String REQUEST_LOG_ENABLED = "requestLog.enabled";
    public static final String MAX_QUEUE_SIZE = "maxQueueSize";
    public static final String CORE_SIZE = "coreSize";
    public static final String KEEP_ALIVE_TIME_MINUTES = "keepAliveTimeMinutes";
    public static final String QUEUE_SIZE_REJECTION_THRESHOLD = "queueSizeRejectionThreshold";
    public static final String METRICS_ROLLING_STATS_NUM_BUCKETS = "metrics.rollingStats.numBuckets";
    public static final String METRICS_ROLLING_STATS_TIME_IN_MILLISECONDS = "metrics.rollingStats.timeInMilliseconds";
    public static final String MAX_REQUESTS_IN_BATCH = "maxRequestsInBatch";
    public static final String TIMER_DELAY_IN_MILLISECONDS = "timerDelayInMilliseconds";
    private static final Map<String, PropSetter<HystrixCommandProperties.Setter, String>> CMD_PROP_MAP = ImmutableMap.builder().put((Object)"execution.isolation.strategy", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withExecutionIsolationStrategy((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixPropertiesManager.toEnum((String)HystrixPropertiesManager.EXECUTION_ISOLATION_STRATEGY, (String)value, (Class)HystrixCommandProperties.ExecutionIsolationStrategy.class, (Enum[])((Enum[])HystrixCommandProperties.ExecutionIsolationStrategy.values())));
        }
    }).put((Object)"execution.isolation.thread.timeoutInMilliseconds", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withExecutionTimeoutInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value));
        }
    }).put((Object)"execution.timeout.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withExecutionTimeoutEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"execution.isolation.thread.interruptOnTimeout", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withExecutionIsolationThreadInterruptOnTimeout(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"execution.isolation.semaphore.maxConcurrentRequests", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withExecutionIsolationSemaphoreMaxConcurrentRequests(HystrixPropertiesManager.toInt(HystrixPropertiesManager.EXECUTION_ISOLATION_SEMAPHORE_MAX_CONCURRENT_REQUESTS, value));
        }
    }).put((Object)"fallback.isolation.semaphore.maxConcurrentRequests", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withFallbackIsolationSemaphoreMaxConcurrentRequests(HystrixPropertiesManager.toInt(HystrixPropertiesManager.FALLBACK_ISOLATION_SEMAPHORE_MAX_CONCURRENT_REQUESTS, value));
        }
    }).put((Object)"fallback.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withFallbackEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"circuitBreaker.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"circuitBreaker.requestVolumeThreshold", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerRequestVolumeThreshold(HystrixPropertiesManager.toInt(HystrixPropertiesManager.CIRCUIT_BREAKER_REQUEST_VOLUME_THRESHOLD, value));
        }
    }).put((Object)"circuitBreaker.sleepWindowInMilliseconds", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerSleepWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.CIRCUIT_BREAKER_SLEEP_WINDOW_IN_MILLISECONDS, value));
        }
    }).put((Object)"circuitBreaker.errorThresholdPercentage", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerErrorThresholdPercentage(HystrixPropertiesManager.toInt(HystrixPropertiesManager.CIRCUIT_BREAKER_ERROR_THRESHOLD_PERCENTAGE, value));
        }
    }).put((Object)"circuitBreaker.forceOpen", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerForceOpen(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"circuitBreaker.forceClosed", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withCircuitBreakerForceClosed(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"metrics.rollingStats.timeInMilliseconds", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingStatisticalWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_TIME_IN_MILLISECONDS, value));
        }
    }).put((Object)"metrics.rollingStats.numBuckets", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingStatisticalWindowBuckets(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_NUM_BUCKETS, value));
        }
    }).put((Object)"metrics.rollingPercentile.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"metrics.rollingPercentile.timeInMilliseconds", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_TIME_IN_MILLISECONDS, value));
        }
    }).put((Object)"metrics.rollingPercentile.numBuckets", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileWindowBuckets(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_NUM_BUCKETS, value));
        }
    }).put((Object)"metrics.rollingPercentile.bucketSize", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileBucketSize(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_BUCKET_SIZE, value));
        }
    }).put((Object)"metrics.healthSnapshot.intervalInMilliseconds", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsHealthSnapshotIntervalInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_HEALTH_SNAPSHOT_INTERVAL_IN_MILLISECONDS, value));
        }
    }).put((Object)"requestCache.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withRequestCacheEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"requestLog.enabled", (Object)new PropSetter<HystrixCommandProperties.Setter, String>(){

        @Override
        public void set(HystrixCommandProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withRequestLogEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).build();
    private static final Map<String, PropSetter<HystrixThreadPoolProperties.Setter, String>> TP_PROP_MAP = ImmutableMap.builder().put((Object)"maxQueueSize", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withMaxQueueSize(HystrixPropertiesManager.toInt(HystrixPropertiesManager.MAX_QUEUE_SIZE, value));
        }
    }).put((Object)"coreSize", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withCoreSize(HystrixPropertiesManager.toInt(HystrixPropertiesManager.CORE_SIZE, value));
        }
    }).put((Object)"keepAliveTimeMinutes", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withKeepAliveTimeMinutes(HystrixPropertiesManager.toInt(HystrixPropertiesManager.KEEP_ALIVE_TIME_MINUTES, value));
        }
    }).put((Object)"queueSizeRejectionThreshold", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withQueueSizeRejectionThreshold(HystrixPropertiesManager.toInt(HystrixPropertiesManager.QUEUE_SIZE_REJECTION_THRESHOLD, value));
        }
    }).put((Object)"metrics.rollingStats.numBuckets", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withMetricsRollingStatisticalWindowBuckets(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_NUM_BUCKETS, value));
        }
    }).put((Object)"metrics.rollingStats.timeInMilliseconds", (Object)new PropSetter<HystrixThreadPoolProperties.Setter, String>(){

        @Override
        public void set(HystrixThreadPoolProperties.Setter setter, String value) {
            setter.withMetricsRollingStatisticalWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_TIME_IN_MILLISECONDS, value));
        }
    }).build();
    private static final Map<String, PropSetter<HystrixCollapserProperties.Setter, String>> COLLAPSER_PROP_MAP = ImmutableMap.builder().put((Object)"timerDelayInMilliseconds", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) {
            setter.withTimerDelayInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.TIMER_DELAY_IN_MILLISECONDS, value));
        }
    }).put((Object)"maxRequestsInBatch", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) {
            setter.withMaxRequestsInBatch(HystrixPropertiesManager.toInt(HystrixPropertiesManager.MAX_REQUESTS_IN_BATCH, value));
        }
    }).put((Object)"metrics.rollingStats.timeInMilliseconds", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingStatisticalWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_TIME_IN_MILLISECONDS, value));
        }
    }).put((Object)"metrics.rollingStats.numBuckets", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingStatisticalWindowBuckets(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_STATS_NUM_BUCKETS, value));
        }
    }).put((Object)"metrics.rollingPercentile.enabled", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).put((Object)"metrics.rollingPercentile.timeInMilliseconds", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileWindowInMilliseconds(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_TIME_IN_MILLISECONDS, value));
        }
    }).put((Object)"metrics.rollingPercentile.numBuckets", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileWindowBuckets(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_NUM_BUCKETS, value));
        }
    }).put((Object)"metrics.rollingPercentile.bucketSize", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withMetricsRollingPercentileBucketSize(HystrixPropertiesManager.toInt(HystrixPropertiesManager.METRICS_ROLLING_PERCENTILE_BUCKET_SIZE, value));
        }
    }).put((Object)"requestCache.enabled", (Object)new PropSetter<HystrixCollapserProperties.Setter, String>(){

        @Override
        public void set(HystrixCollapserProperties.Setter setter, String value) throws IllegalArgumentException {
            setter.withRequestCacheEnabled(HystrixPropertiesManager.toBoolean(value));
        }
    }).build();

    private HystrixPropertiesManager() {
    }

    public static HystrixCommandProperties.Setter initializeCommandProperties(HystrixProperty[] properties) throws IllegalArgumentException {
        return HystrixPropertiesManager.initializeProperties(HystrixCommandProperties.Setter(), properties, CMD_PROP_MAP, "command");
    }

    public static HystrixThreadPoolProperties.Setter initializeThreadPoolProperties(HystrixProperty[] properties) throws IllegalArgumentException {
        return HystrixPropertiesManager.initializeProperties(HystrixThreadPoolProperties.Setter(), properties, TP_PROP_MAP, "thread pool");
    }

    public static HystrixCollapserProperties.Setter initializeCollapserProperties(HystrixProperty[] properties) {
        return HystrixPropertiesManager.initializeProperties(HystrixCollapserProperties.Setter(), properties, COLLAPSER_PROP_MAP, "collapser");
    }

    private static <S> S initializeProperties(S setter, HystrixProperty[] properties, Map<String, PropSetter<S, String>> propMap, String type) {
        if (properties != null && properties.length > 0) {
            for (HystrixProperty property : properties) {
                HystrixPropertiesManager.validate(property);
                if (!propMap.containsKey(property.name())) {
                    throw new IllegalArgumentException("unknown " + type + " property: " + property.name());
                }
                propMap.get(property.name()).set(setter, property.value());
            }
        }
        return setter;
    }

    private static void validate(HystrixProperty hystrixProperty) throws IllegalArgumentException {
        Validate.notBlank((CharSequence)hystrixProperty.name(), (String)"hystrix property name cannot be null or blank", (Object[])new Object[0]);
    }

    private static <E extends Enum<E>> E toEnum(String propName, String propValue, Class<E> enumType, E ... values) throws IllegalArgumentException {
        try {
            return Enum.valueOf(enumType, propValue);
        }
        catch (NullPointerException npe) {
            throw HystrixPropertiesManager.createBadEnumError(propName, propValue, values);
        }
        catch (IllegalArgumentException e) {
            throw HystrixPropertiesManager.createBadEnumError(propName, propValue, values);
        }
    }

    private static int toInt(String propName, String propValue) throws IllegalArgumentException {
        try {
            return Integer.parseInt(propValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad property value. property name '" + propName + "'. Expected int value, actual = " + propValue);
        }
    }

    private static boolean toBoolean(String propValue) {
        return Boolean.valueOf(propValue);
    }

    private static IllegalArgumentException createBadEnumError(String propName, String propValue, Enum ... values) {
        throw new IllegalArgumentException("bad property value. property name '" + propName + "'. Expected correct enum value, one of the [" + Arrays.toString(values) + "] , actual = " + propValue);
    }

    private static interface PropSetter<S, V> {
        public void set(S var1, V var2) throws IllegalArgumentException;
    }
}

