/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.exception.FallbackDefinitionException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class FallbackMethod {
    private final Method method;
    private final boolean extended;
    private ExecutionType executionType;
    public static final FallbackMethod ABSENT = new FallbackMethod(null, false);

    public FallbackMethod(Method method, boolean extended) {
        this.method = method;
        this.extended = extended;
        if (method != null) {
            this.executionType = ExecutionType.getExecutionType(method.getReturnType());
        }
    }

    public boolean isCommand() {
        return this.method.isAnnotationPresent(HystrixCommand.class);
    }

    public boolean isPresent() {
        return this.method != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void validateReturnType(Method commandMethod) {
        if (this.isPresent()) {
            Class<?> returnType = commandMethod.getReturnType();
            if (ExecutionType.OBSERVABLE == ExecutionType.getExecutionType(returnType)) {
                return;
            }
            if (ExecutionType.ASYNCHRONOUS == ExecutionType.getExecutionType(returnType)) {
                Class<?> commandActualReturnType = this.getGenReturnType(commandMethod);
                if (commandActualReturnType != null) {
                    Class<?> fallbackActualReturnType;
                    if (this.isCommand() && ExecutionType.ASYNCHRONOUS == this.getExecutionType() && (fallbackActualReturnType = this.getGenReturnType(this.method)) != null && !commandActualReturnType.isAssignableFrom(fallbackActualReturnType)) {
                        throw new FallbackDefinitionException("fallback method is async and must be parametrized with: " + commandActualReturnType);
                    }
                    if (this.isCommand() && ExecutionType.SYNCHRONOUS == this.getExecutionType() && !commandActualReturnType.isAssignableFrom(this.method.getReturnType())) {
                        throw new FallbackDefinitionException("fallback method '" + this.method + "' must return : " + commandActualReturnType + " or it's subclass");
                    }
                    if (!this.isCommand() && !commandActualReturnType.isAssignableFrom(this.method.getReturnType())) {
                        throw new FallbackDefinitionException("fallback method '" + this.method + "' must return : " + commandActualReturnType + " or it's subclass");
                    }
                }
            } else if (!commandMethod.getReturnType().isAssignableFrom(this.method.getReturnType())) {
                throw new FallbackDefinitionException("fallback method '" + this.method + "' must return : " + commandMethod.getReturnType() + " or it's subclass");
            }
        }
    }

    private Class<?> getGenReturnType(Method m) {
        Type type = m.getGenericReturnType();
        if (type != null) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getActualTypeArguments()[0];
        }
        return null;
    }
}

