/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.collect.ImmutableList;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheResult;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericSetterBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HystrixCommandBuilder {
    private final GenericSetterBuilder setterBuilder;
    private final CommandActions commandActions;
    private final CacheInvocationContext<CacheResult> cacheResultInvocationContext;
    private final CacheInvocationContext<CacheRemove> cacheRemoveInvocationContext;
    private final Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests;
    private final List<Class<? extends Throwable>> ignoreExceptions;
    private final ExecutionType executionType;

    public HystrixCommandBuilder(Builder builder) {
        this.setterBuilder = builder.setterBuilder;
        this.commandActions = builder.commandActions;
        this.cacheResultInvocationContext = builder.cacheResultInvocationContext;
        this.cacheRemoveInvocationContext = builder.cacheRemoveInvocationContext;
        this.collapsedRequests = builder.collapsedRequests;
        this.ignoreExceptions = builder.ignoreExceptions;
        this.executionType = builder.executionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GenericSetterBuilder getSetterBuilder() {
        return this.setterBuilder;
    }

    public CommandActions getCommandActions() {
        return this.commandActions;
    }

    public CacheInvocationContext<CacheResult> getCacheResultInvocationContext() {
        return this.cacheResultInvocationContext;
    }

    public CacheInvocationContext<CacheRemove> getCacheRemoveInvocationContext() {
        return this.cacheRemoveInvocationContext;
    }

    public Collection<HystrixCollapser.CollapsedRequest<Object, Object>> getCollapsedRequests() {
        return this.collapsedRequests;
    }

    public List<Class<? extends Throwable>> getIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public static class Builder {
        private GenericSetterBuilder setterBuilder;
        private CommandActions commandActions;
        private CacheInvocationContext<CacheResult> cacheResultInvocationContext;
        private CacheInvocationContext<CacheRemove> cacheRemoveInvocationContext;
        private Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests = Collections.emptyList();
        private List<Class<? extends Throwable>> ignoreExceptions = Collections.emptyList();
        private ExecutionType executionType = ExecutionType.SYNCHRONOUS;

        public Builder setterBuilder(GenericSetterBuilder pSetterBuilder) {
            this.setterBuilder = pSetterBuilder;
            return this;
        }

        public Builder commandActions(CommandActions pCommandActions) {
            this.commandActions = pCommandActions;
            return this;
        }

        public Builder cacheResultInvocationContext(CacheInvocationContext<CacheResult> pCacheResultInvocationContext) {
            this.cacheResultInvocationContext = pCacheResultInvocationContext;
            return this;
        }

        public Builder cacheRemoveInvocationContext(CacheInvocationContext<CacheRemove> pCacheRemoveInvocationContext) {
            this.cacheRemoveInvocationContext = pCacheRemoveInvocationContext;
            return this;
        }

        public Builder collapsedRequests(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> pCollapsedRequests) {
            this.collapsedRequests = pCollapsedRequests;
            return this;
        }

        public Builder ignoreExceptions(Class<? extends Throwable>[] pIgnoreExceptions) {
            this.ignoreExceptions = ImmutableList.copyOf((Object[])pIgnoreExceptions);
            return this;
        }

        public Builder executionType(ExecutionType pExecutionType) {
            this.executionType = pExecutionType;
            return this;
        }

        public HystrixCommandBuilder build() {
            return new HystrixCommandBuilder(this);
        }
    }
}

