/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.contrib.javanica.collapser.CommandCollapser;
import com.netflix.hystrix.contrib.javanica.command.GenericCommand;
import com.netflix.hystrix.contrib.javanica.command.GenericObservableCommand;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilderFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;

public class HystrixCommandFactory {
    private static final HystrixCommandFactory INSTANCE = new HystrixCommandFactory();

    private HystrixCommandFactory() {
    }

    public static HystrixCommandFactory getInstance() {
        return INSTANCE;
    }

    public HystrixInvokable create(MetaHolder metaHolder) {
        Object executable = metaHolder.isCollapserAnnotationPresent() ? new CommandCollapser(metaHolder) : (metaHolder.isObservable() ? new GenericObservableCommand(HystrixCommandBuilderFactory.getInstance().create(metaHolder)) : new GenericCommand(HystrixCommandBuilderFactory.getInstance().create(metaHolder)));
        return executable;
    }

    public HystrixInvokable createDelayed(MetaHolder metaHolder) {
        Object executable = metaHolder.isObservable() ? new GenericObservableCommand(HystrixCommandBuilderFactory.getInstance().create(metaHolder)) : new GenericCommand(HystrixCommandBuilderFactory.getInstance().create(metaHolder));
        return executable;
    }
}

