/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import com.netflix.hystrix.contrib.javanica.exception.HystrixPropertyException;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class GenericSetterBuilder {
    private String groupKey;
    private String commandKey;
    private String threadPoolKey;
    private String collapserKey;
    private HystrixCollapser.Scope scope;
    private List<HystrixProperty> commandProperties = Collections.emptyList();
    private List<HystrixProperty> collapserProperties = Collections.emptyList();
    private List<HystrixProperty> threadPoolProperties = Collections.emptyList();

    public GenericSetterBuilder(Builder builder) {
        this.groupKey = builder.groupKey;
        this.commandKey = builder.commandKey;
        this.threadPoolKey = builder.threadPoolKey;
        this.collapserKey = builder.collapserKey;
        this.scope = builder.scope;
        this.commandProperties = builder.commandProperties;
        this.collapserProperties = builder.collapserProperties;
        this.threadPoolProperties = builder.threadPoolProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HystrixCommand.Setter build() throws HystrixPropertyException {
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)this.groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)this.commandKey));
        if (StringUtils.isNotBlank((CharSequence)this.threadPoolKey)) {
            setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)this.threadPoolKey));
        }
        try {
            setter.andThreadPoolPropertiesDefaults(HystrixPropertiesManager.initializeThreadPoolProperties(this.threadPoolProperties));
        }
        catch (IllegalArgumentException e) {
            throw new HystrixPropertyException("Failed to set Thread Pool properties. " + this.getInfo(), e);
        }
        try {
            setter.andCommandPropertiesDefaults(HystrixPropertiesManager.initializeCommandProperties(this.commandProperties));
        }
        catch (IllegalArgumentException e) {
            throw new HystrixPropertyException("Failed to set Command properties. " + this.getInfo(), e);
        }
        return setter;
    }

    public HystrixObservableCommand.Setter buildObservableCommandSetter() {
        HystrixObservableCommand.Setter setter = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)this.groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)this.commandKey));
        try {
            setter.andCommandPropertiesDefaults(HystrixPropertiesManager.initializeCommandProperties(this.commandProperties));
        }
        catch (IllegalArgumentException e) {
            throw new HystrixPropertyException("Failed to set Command properties. " + this.getInfo(), e);
        }
        return setter;
    }

    public HystrixCollapser.Setter buildCollapserCommandSetter() {
        HystrixCollapserProperties.Setter propSetter = HystrixPropertiesManager.initializeCollapserProperties(this.collapserProperties);
        return HystrixCollapser.Setter.withCollapserKey((HystrixCollapserKey)HystrixCollapserKey.Factory.asKey((String)this.collapserKey)).andScope(this.scope).andCollapserPropertiesDefaults(propSetter);
    }

    private String getInfo() {
        return "groupKey: '" + this.groupKey + "', commandKey: '" + this.commandKey + "', threadPoolKey: '" + this.threadPoolKey + "'";
    }

    public static class Builder {
        private String groupKey;
        private String commandKey;
        private String threadPoolKey;
        private String collapserKey;
        private HystrixCollapser.Scope scope;
        private List<HystrixProperty> commandProperties = Collections.emptyList();
        private List<HystrixProperty> collapserProperties = Collections.emptyList();
        private List<HystrixProperty> threadPoolProperties = Collections.emptyList();

        public Builder groupKey(String pGroupKey) {
            this.groupKey = pGroupKey;
            return this;
        }

        public Builder groupKey(String pGroupKey, String def) {
            this.groupKey = StringUtils.isNotEmpty((CharSequence)pGroupKey) ? pGroupKey : def;
            return this;
        }

        public Builder commandKey(String pCommandKey) {
            this.commandKey = pCommandKey;
            return this;
        }

        @Deprecated
        public Builder commandKey(String pCommandKey, String def) {
            this.commandKey = StringUtils.isNotEmpty((CharSequence)pCommandKey) ? pCommandKey : def;
            return this;
        }

        public Builder collapserKey(String pCollapserKey) {
            this.collapserKey = pCollapserKey;
            return this;
        }

        public Builder scope(HystrixCollapser.Scope pScope) {
            this.scope = pScope;
            return this;
        }

        public Builder collapserProperties(List<HystrixProperty> properties) {
            this.collapserProperties = properties;
            return this;
        }

        public Builder commandProperties(List<HystrixProperty> properties) {
            this.commandProperties = properties;
            return this;
        }

        public Builder threadPoolProperties(List<HystrixProperty> properties) {
            this.threadPoolProperties = properties;
            return this;
        }

        public Builder threadPoolKey(String pThreadPoolKey) {
            this.threadPoolKey = pThreadPoolKey;
            return this;
        }

        public GenericSetterBuilder build() {
            return new GenericSetterBuilder(this);
        }
    }
}

