/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.requestservlet;

import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestLogViaLoggerServletFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestLogViaLoggerServletFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StringBuilder requestURL = new StringBuilder();
        try {
            String uri = ((HttpServletRequest)request).getRequestURI();
            String queryString = ((HttpServletRequest)request).getQueryString();
            String method = ((HttpServletRequest)request).getMethod();
            requestURL.append(method).append(" ").append(uri);
            if (queryString != null) {
                requestURL.append("?").append(queryString);
            }
            chain.doFilter(request, response);
        }
        finally {
            try {
                if (HystrixRequestContext.isCurrentThreadInitialized()) {
                    HystrixRequestLog log = HystrixRequestLog.getCurrentRequest();
                    logger.info("Hystrix Executions [" + requestURL.toString() + "] => " + log.getExecutedCommandsAsString());
                }
            }
            catch (Exception e) {
                logger.warn("Unable to append HystrixRequestLog", (Throwable)e);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

