/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.requestservlet;

import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestLogViaResponseHeaderServletFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestLogViaResponseHeaderServletFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            try {
                HystrixRequestLog log;
                if (HystrixRequestContext.isCurrentThreadInitialized() && (log = HystrixRequestLog.getCurrentRequest()) != null) {
                    ((HttpServletResponse)response).addHeader("X-HystrixLog", log.getExecutedCommandsAsString());
                }
            }
            catch (Exception e) {
                logger.warn("Unable to append HystrixRequestLog", (Throwable)e);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

