/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.netflix.archaius.ConfigProxyFactory;
import com.netflix.governator.event.ApplicationEventDispatcher;
import com.netflix.governator.event.guava.GuavaApplicationEventModule;
import com.netflix.runtime.health.api.HealthCheckAggregator;
import com.netflix.runtime.health.api.HealthIndicator;
import com.netflix.runtime.health.core.SimpleHealthCheckAggregator;
import com.netflix.runtime.health.core.caching.DefaultCachingHealthCheckAggregator;
import com.netflix.runtime.health.guice.HealthAggregatorConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.inject.Singleton;

public class HealthModule
extends AbstractModule {
    protected final void configure() {
        this.install((Module)new InternalHealthModule());
        this.configureHealth();
    }

    protected void configureHealth() {
    }

    protected final LinkedBindingBuilder<HealthIndicator> bindAdditionalHealthIndicator() {
        return Multibinder.newSetBinder((Binder)this.binder(), HealthIndicator.class).addBinding();
    }

    private static class HealthProvider
    implements Provider<HealthCheckAggregator> {
        @Inject(optional=true)
        private Set<HealthIndicator> indicators;
        @Inject
        private HealthAggregatorConfiguration config;
        @Inject
        private ApplicationEventDispatcher dispatcher;

        private HealthProvider() {
        }

        public HealthCheckAggregator get() {
            if (this.indicators == null) {
                this.indicators = Collections.emptySet();
            }
            if (this.config.cacheHealthIndicators()) {
                return new DefaultCachingHealthCheckAggregator(new ArrayList<HealthIndicator>(this.indicators), this.config.getCacheIntervalInMillis(), TimeUnit.MILLISECONDS, this.config.getAggregatorWaitIntervalInMillis(), TimeUnit.MILLISECONDS, this.dispatcher);
            }
            return new SimpleHealthCheckAggregator(new ArrayList<HealthIndicator>(this.indicators), this.config.getAggregatorWaitIntervalInMillis(), TimeUnit.MILLISECONDS, this.dispatcher);
        }
    }

    private static final class InternalHealthModule
    extends AbstractModule {
        private InternalHealthModule() {
        }

        @Provides
        @Singleton
        public HealthAggregatorConfiguration healthConfiguration(ConfigProxyFactory factory) {
            return (HealthAggregatorConfiguration)factory.newProxy(HealthAggregatorConfiguration.class);
        }

        protected void configure() {
            this.install((Module)new GuavaApplicationEventModule());
            this.requireBinding(Key.get(ConfigProxyFactory.class));
            this.bind(HealthCheckAggregator.class).toProvider(HealthProvider.class).asEagerSingleton();
        }

        public boolean equals(Object obj) {
            return ((Object)((Object)this)).getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public String toString() {
            return "InternalHealthModule[]";
        }
    }
}

