/*
 * Decompiled with CFR 0.152.
 */
package rx.android.observables;

import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import rx.Observable;
import rx.android.observables.Assertions;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.operators.OperatorObserveFromAndroidComponent;
import rx.operators.OperatorWeakBinding;

public final class AndroidObservable {
    private static final boolean USES_SUPPORT_FRAGMENTS;
    private static final Func1<Activity, Boolean> ACTIVITY_VALIDATOR;
    private static final Func1<Fragment, Boolean> FRAGMENT_VALIDATOR;
    private static final Func1<android.support.v4.app.Fragment, Boolean> FRAGMENTV4_VALIDATOR;

    private AndroidObservable() {
    }

    @Deprecated
    public static <T> Observable<T> fromActivity(Activity activity, Observable<T> sourceObservable) {
        Assertions.assertUiThread();
        return OperatorObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, activity);
    }

    @Deprecated
    public static <T> Observable<T> fromFragment(Object fragment, Observable<T> sourceObservable) {
        Assertions.assertUiThread();
        if (USES_SUPPORT_FRAGMENTS && fragment instanceof android.support.v4.app.Fragment) {
            return OperatorObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (android.support.v4.app.Fragment)fragment);
        }
        if (Build.VERSION.SDK_INT >= 11 && fragment instanceof Fragment) {
            return OperatorObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (Fragment)fragment);
        }
        throw new IllegalArgumentException("Target fragment is neither a native nor support library Fragment");
    }

    public static <T> Observable<T> bindActivity(Activity activity, Observable<T> source) {
        Assertions.assertUiThread();
        return source.observeOn(AndroidSchedulers.mainThread()).lift(new OperatorWeakBinding(activity, ACTIVITY_VALIDATOR));
    }

    public static <T> Observable<T> bindFragment(Object fragment, Observable<T> cachedSequence) {
        Assertions.assertUiThread();
        Observable source = cachedSequence.observeOn(AndroidSchedulers.mainThread());
        if (USES_SUPPORT_FRAGMENTS && fragment instanceof android.support.v4.app.Fragment) {
            android.support.v4.app.Fragment f = (android.support.v4.app.Fragment)fragment;
            return source.lift(new OperatorWeakBinding(f, FRAGMENTV4_VALIDATOR));
        }
        if (Build.VERSION.SDK_INT >= 11 && fragment instanceof Fragment) {
            Fragment f = (Fragment)fragment;
            return source.lift(new OperatorWeakBinding(f, FRAGMENT_VALIDATOR));
        }
        throw new IllegalArgumentException("Target fragment is neither a native nor support library Fragment");
    }

    static {
        boolean supportFragmentsAvailable = false;
        try {
            Class.forName("android.support.v4.app.Fragment");
            supportFragmentsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_SUPPORT_FRAGMENTS = supportFragmentsAvailable;
        ACTIVITY_VALIDATOR = new Func1<Activity, Boolean>(){

            public Boolean call(Activity activity) {
                return !activity.isFinishing();
            }
        };
        FRAGMENT_VALIDATOR = new Func1<Fragment, Boolean>(){

            public Boolean call(Fragment fragment) {
                return fragment.isAdded();
            }
        };
        FRAGMENTV4_VALIDATOR = new Func1<android.support.v4.app.Fragment, Boolean>(){

            public Boolean call(android.support.v4.app.Fragment fragment) {
                return fragment.isAdded();
            }
        };
    }
}

