/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.ObjectFile;
import java.util.HashMap;
import java.util.Map;

public abstract class SectionName {
    public static final SectionName DATA = new ProgbitsSectionName("data");
    public static final SectionName RODATA = new ProgbitsSectionName("rodata"){

        @Override
        public String getSegmentName(ObjectFile.Format f) {
            String result = f == ObjectFile.Format.MACH_O ? "__DATA" : super.getSegmentName(f);
            return result;
        }

        @Override
        public String getFormatDependentName(ObjectFile.Format f) {
            String result = f == ObjectFile.Format.MACH_O ? "__const" : super.getFormatDependentName(f);
            return result;
        }
    };
    public static final SectionName TEXT = new ProgbitsSectionName("text");
    public static final SectionName BSS = new NobitsSectionName("bss");
    public static final SectionName SVM_HEAP = new ProgbitsSectionName("svm_heap");
    public static final SectionName APPLE_NAMES = new ProgbitsSectionName("apple_names");
    public static final SectionName APPLE_TYPES = new ProgbitsSectionName("apple_types");
    public static final SectionName APPLE_NAMESPACE = new ProgbitsSectionName("apple_namespac");
    public static final SectionName APPLE_OBJC = new ProgbitsSectionName("apple_objc");
    private static final SectionName[] myValues = new SectionName[]{DATA, RODATA, TEXT, BSS, APPLE_NAMES, APPLE_TYPES, APPLE_NAMESPACE, APPLE_OBJC};
    protected static final Map<String, SectionName> NAMES_MAP = new HashMap<String, SectionName>();
    protected final String platformIndependentName;

    private static String getFormatPrefix(ObjectFile.Format f) {
        switch (f) {
            case ELF: 
            case PECOFF: {
                return ".";
            }
            case MACH_O: {
                return "__";
            }
        }
        throw new IllegalStateException("unsupported format: " + (Object)((Object)f));
    }

    public String getSegmentName(ObjectFile.Format f) {
        switch (f) {
            case MACH_O: {
                return this.getFormatDependentName(f).toUpperCase();
            }
        }
        return null;
    }

    public String getPlatformIndependentName() {
        return this.platformIndependentName;
    }

    protected SectionName(String n) {
        this.platformIndependentName = n;
    }

    public String getFormatDependentName(ObjectFile.Format f) {
        return SectionName.getFormatPrefix(f) + this.platformIndependentName;
    }

    public static SectionName from(String n) {
        SectionName result = NAMES_MAP.get(n);
        return result;
    }

    static {
        for (SectionName name : myValues) {
            for (ObjectFile.Format f : ObjectFile.Format.values()) {
                NAMES_MAP.put(name.getFormatDependentName(f), name);
            }
        }
    }

    private static class NobitsSectionName
    extends SectionName {
        NobitsSectionName(String name) {
            super(name);
        }
    }

    private static class ProgbitsSectionName
    extends SectionName {
        ProgbitsSectionName(String name) {
            super(name);
        }
    }
}

