/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IServerResource;
import java.util.Date;

public interface IDepot
extends IServerResource {
    public String getName();

    public String getOwnerName();

    public Date getModDate();

    public String getDescription();

    public DepotType getDepotType();

    public String getAddress();

    public String getSuffix();

    public String getMap();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DepotType {
        LOCAL,
        REMOTE,
        SPEC,
        STREAM,
        ARCHIVE,
        UNLOAD,
        UNKNOWN;


        public static DepotType fromString(String str) {
            if (str == null) {
                return null;
            }
            try {
                return DepotType.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                Log.error("Bad conversion attempt in DepotType.fromString; string: " + str + "; message: " + iae.getMessage());
                Log.exception(iae);
                return UNKNOWN;
            }
        }
    }
}

