/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelSummary
extends ServerResource
implements ILabelSummary {
    protected static final String LOCKED_VALUE = "locked";
    protected static final String UNLOCKED_VALUE = "unlocked";
    protected static final String AUTORELOAD_VALUE = "autoreload";
    protected static final String NOAUTORELOAD_VALUE = "noautoreload";
    protected String name = null;
    protected String ownerName = null;
    protected Date lastAccess = null;
    protected Date lastUpdate = null;
    protected String description = null;
    protected String revisionSpec = null;
    protected boolean locked = false;
    protected boolean unloaded = false;
    protected boolean autoreload = false;

    public LabelSummary() {
        super(false, false);
    }

    public LabelSummary(boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
    }

    public LabelSummary(Map<String, Object> map) {
        super(false, false);
        if (map != null) {
            try {
                String[] optParts;
                this.name = (String)map.get("label");
                this.description = (String)map.get("Description");
                if (this.description != null) {
                    this.description = this.description.trim();
                }
                this.ownerName = (String)map.get("Owner");
                this.lastUpdate = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                this.lastAccess = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                this.revisionSpec = (String)map.get("Revision");
                String optStr = (String)map.get("Options");
                if (optStr != null && (optParts = optStr.split("\\s+")) != null && optParts.length > 0) {
                    for (String optPart : optParts) {
                        if (optPart.equalsIgnoreCase(LOCKED_VALUE)) {
                            this.locked = true;
                            continue;
                        }
                        if (optPart.equalsIgnoreCase(UNLOCKED_VALUE)) {
                            this.locked = false;
                            continue;
                        }
                        if (optPart.equalsIgnoreCase(AUTORELOAD_VALUE)) {
                            this.autoreload = true;
                            continue;
                        }
                        if (!optPart.equalsIgnoreCase(NOAUTORELOAD_VALUE)) continue;
                        this.autoreload = false;
                    }
                }
                if (map.get("IsUnloaded") != null && ((String)map.get("IsUnloaded")).equals("1")) {
                    this.unloaded = true;
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in LabelSummary constructor: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public Date getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRevisionSpec() {
        return this.revisionSpec;
    }

    @Override
    public void setRevisionSpec(String revisionSpec) {
        this.revisionSpec = revisionSpec;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isAutoReload() {
        return this.autoreload;
    }

    @Override
    public void setAutoReload(boolean autoreload) {
        this.autoreload = autoreload;
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }
}

