/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.util;

import com.perforce.p4java.Log;
import java.util.Arrays;
import java.util.Properties;

public class PropertiesHelper {
    public static String getProperty(Properties props, String[] keys) {
        return PropertiesHelper.getProperty(props, keys, null);
    }

    public static String getProperty(Properties props, String[] keys, String defaultValue) {
        if (props != null && keys != null) {
            String propStr = null;
            for (String key : keys) {
                if (key == null) continue;
                if (props.get(key) != null) {
                    propStr = String.valueOf(props.get(key));
                }
                if (propStr == null) continue;
                return propStr;
            }
        }
        return defaultValue;
    }

    public static int getPropertyAsInt(Properties props, String[] keys, int defaultValue) {
        String propStr = PropertiesHelper.getProperty(props, keys, null);
        int retVal = defaultValue;
        if (propStr != null) {
            try {
                retVal = new Integer(propStr);
            }
            catch (Exception exc) {
                Log.warn("Integer property conversion error; prop name: '" + Arrays.toString(keys) + "'; prop value: " + propStr);
                Log.exception(exc);
            }
        }
        return retVal;
    }

    public static long getPropertyAsLong(Properties props, String[] keys, long defaultValue) {
        String propStr = PropertiesHelper.getProperty(props, keys, null);
        long retVal = defaultValue;
        if (propStr != null) {
            try {
                retVal = new Long(propStr);
            }
            catch (Exception exc) {
                Log.warn("Long property conversion error; prop name: '" + Arrays.toString(keys) + "'; prop value: " + propStr);
                Log.exception(exc);
            }
        }
        return retVal;
    }
}

