/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.constraint.ConstraintEvaluator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;

public class GenerationContext
implements GenerationStatus {
    private final ParameterContext parameter;
    private final GeometricDistribution distro;
    private final ConstraintEvaluator evaluator;
    private final SourceOfRandomness random;
    private final Generator<?> generator;
    private int successfulEvaluations;
    private int discards;

    public GenerationContext(ParameterContext parameter, GeneratorRepository repository, GeometricDistribution distro, SourceOfRandomness random) {
        this.parameter = parameter;
        this.distro = distro;
        this.evaluator = new ConstraintEvaluator(parameter.constraint());
        this.random = random;
        this.generator = repository.produceGenerator(parameter.typeContext());
    }

    public Object generate(SourceOfRandomness random) {
        Object nextValue = this.generator.generate(random, this);
        while (!this.evaluate(nextValue) && this.shouldContinue()) {
            nextValue = this.generator.generate(random, this);
        }
        return nextValue;
    }

    private boolean evaluate(Object value) {
        this.evaluator.bind(value);
        boolean result = this.evaluator.evaluate();
        if (result) {
            ++this.successfulEvaluations;
        } else {
            ++this.discards;
        }
        if (this.tooManyDiscards()) {
            throw new DiscardRatioExceededException(this.parameter, this.discards, this.successfulEvaluations);
        }
        return result;
    }

    public boolean shouldContinue() {
        return this.needMoreAttempts() && !this.tooManyDiscards();
    }

    private boolean needMoreAttempts() {
        return this.successfulEvaluations < this.parameter.sampleSize();
    }

    private boolean tooManyDiscards() {
        if (this.parameter.discardRatio() < 0) {
            return true;
        }
        if (this.parameter.discardRatio() == 0) {
            return this.discards > this.parameter.sampleSize();
        }
        return this.successfulEvaluations == 0 ? this.discards > this.parameter.discardRatio() : this.discards / this.successfulEvaluations >= this.parameter.discardRatio();
    }

    @Override
    public int size() {
        int sample = this.distro.sampleWithMean(this.attempts() + 1, this.random);
        return Math.min(sample, this.parameter.sampleSize());
    }

    @Override
    public int attempts() {
        return this.successfulEvaluations + this.discards;
    }

    public static class DiscardRatioExceededException
    extends RuntimeException {
        static final String MESSAGE_TEMPLATE = "For parameter with discard ratio [%d], %d unsuccessful values and %d successes for a discard ratio of [%f]. Stopping.";
        private static final long serialVersionUID = Long.MIN_VALUE;

        DiscardRatioExceededException(ParameterContext parameter, int discards, int successfulEvaluations) {
            super(String.format(MESSAGE_TEMPLATE, parameter.discardRatio(), discards, successfulEvaluations, (double)discards / (double)successfulEvaluations));
        }
    }
}

