/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.internal.generator.ArrayGenerator;
import com.pholser.junit.quickcheck.internal.generator.CompositeGenerator;
import com.pholser.junit.quickcheck.internal.generator.EnumGenerator;
import com.pholser.junit.quickcheck.internal.generator.LambdaGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;

public class GeneratorRepository {
    private final SourceOfRandomness random;
    private final Map<Class<?>, Set<Generator<?>>> generators = new HashMap();

    public GeneratorRepository(SourceOfRandomness random) {
        this.random = random;
    }

    public GeneratorRepository register(Generator<?> source) {
        this.registerTypes(source);
        return this;
    }

    public GeneratorRepository register(Iterable<Generator<?>> source) {
        for (Generator<?> each : source) {
            this.registerTypes(each);
        }
        return this;
    }

    private void registerTypes(Generator<?> generator) {
        for (Class<?> each : generator.types()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void registerHierarchy(Class<?> type, Generator<?> generator) {
        this.maybeRegisterGeneratorForType(type, generator);
        if (type.getSuperclass() != null) {
            this.registerHierarchy(type.getSuperclass(), generator);
        } else if (type.isInterface()) {
            this.registerHierarchy(Object.class, generator);
        }
        for (Class<?> each : type.getInterfaces()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void maybeRegisterGeneratorForType(Class<?> type, Generator<?> generator) {
        if (generator.canRegisterAsType(type)) {
            this.registerGeneratorForType(type, generator);
        }
    }

    private void registerGeneratorForType(Class<?> type, Generator<?> generator) {
        Set<Generator<?>> forType = this.generators.get(type);
        if (forType == null) {
            forType = new LinkedHashSet();
            this.generators.put(type, forType);
        }
        forType.add(generator);
    }

    public Generator<?> produceGenerator(ParameterTypeContext parameter) {
        Generator<?> generator = this.generatorFor(parameter);
        generator.provideRepository(this);
        generator.configure(parameter.annotatedType());
        return generator;
    }

    public Generator<?> generatorFor(ParameterTypeContext parameter) {
        if (!parameter.explicitGenerators().isEmpty()) {
            return this.composeWeighted(parameter, parameter.explicitGenerators());
        }
        if (parameter.isArray()) {
            return this.generatorForArrayType(parameter);
        }
        if (parameter.isEnum()) {
            return new EnumGenerator(parameter.getRawClass());
        }
        return this.compose(parameter, this.matchingGenerators(parameter));
    }

    private Generator<?> generatorForArrayType(ParameterTypeContext parameter) {
        ParameterTypeContext component = parameter.arrayComponentContext();
        return new ArrayGenerator(component.getRawClass(), this.generatorFor(component));
    }

    private List<Generator<?>> matchingGenerators(ParameterTypeContext parameter) {
        ArrayList matches = new ArrayList();
        if (!this.hasGeneratorsFor(parameter)) {
            this.maybeAddLambdaGenerator(parameter, matches);
        } else {
            this.maybeAddGeneratorsFor(parameter, matches);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Cannot find generator for " + parameter.name() + " of type " + parameter.type().getTypeName());
        }
        return matches;
    }

    private void maybeAddLambdaGenerator(ParameterTypeContext parameter, List<Generator<?>> matches) {
        Method method = Reflection.singleAbstractMethodOf(parameter.getRawClass());
        if (method != null) {
            ParameterTypeContext returnType = new ParameterTypeContext("return value", method.getAnnotatedReturnType(), method.getName()).annotate(method.getAnnotatedReturnType()).allowMixedTypes(true);
            Generator<?> returnTypeGenerator = this.generatorFor(returnType);
            LambdaGenerator lambda = new LambdaGenerator(parameter.getRawClass(), returnTypeGenerator);
            matches.add(lambda);
        }
    }

    private void maybeAddGeneratorsFor(ParameterTypeContext parameter, List<Generator<?>> matches) {
        List<Generator<?>> candidates = this.generatorsFor(parameter);
        List<TypeParameter<?>> typeParameters = parameter.getTypeParameters();
        if (typeParameters.isEmpty()) {
            matches.addAll(candidates);
        } else {
            for (Generator<?> each : candidates) {
                if (!each.canGenerateForParametersOfTypes(typeParameters)) continue;
                matches.add(each);
            }
        }
    }

    private Generator<?> compose(ParameterTypeContext parameter, List<Generator<?>> matches) {
        List<Weighted<Generator<?>>> weightings = matches.stream().map(g -> new Weighted<Generator>((Generator)g, 1)).collect(Collectors.toList());
        return this.composeWeighted(parameter, weightings);
    }

    private Generator<?> composeWeighted(ParameterTypeContext parameter, List<Weighted<Generator<?>>> matches) {
        ArrayList forComponents = new ArrayList();
        for (ParameterTypeContext parameterTypeContext : parameter.typeParameterContexts(this.random)) {
            forComponents.add(this.generatorFor(parameterTypeContext));
        }
        for (Weighted weighted : matches) {
            this.applyComponentGenerators((Generator)weighted.item, forComponents);
        }
        return new CompositeGenerator(matches);
    }

    private void applyComponentGenerators(Generator<?> generator, List<Generator<?>> componentGenerators) {
        if (generator.hasComponents()) {
            if (componentGenerators.isEmpty()) {
                ArrayList substitutes = new ArrayList();
                Generator<?> zilch = this.generatorFor(new ParameterTypeContext("Zilch", null, this.getClass().getName(), GeneratorRepository.token(Zilch.class)).allowMixedTypes(true));
                for (int i = 0; i < generator.numberOfNeededComponents(); ++i) {
                    substitutes.add(zilch);
                }
                generator.addComponentGenerators(substitutes);
            } else {
                generator.addComponentGenerators(componentGenerators);
            }
        }
    }

    private List<Generator<?>> generatorsFor(ParameterTypeContext parameter) {
        Set<Generator<?>> matches = this.generators.get(parameter.getRawClass());
        if (!parameter.allowMixedTypes()) {
            Generator<?> match = Items.choose(matches, this.random);
            matches = new HashSet();
            matches.add(match);
        }
        ArrayList copies = new ArrayList();
        for (Generator<?> each : matches) {
            copies.add(GeneratorRepository.copyOf(each));
        }
        return copies;
    }

    private boolean hasGeneratorsFor(ParameterTypeContext parameter) {
        return this.generators.get(parameter.getRawClass()) != null;
    }

    private static Generator<?> copyOf(Generator<?> generator) {
        return (Generator)Reflection.instantiate(generator.getClass());
    }

    public static org.javaruntype.type.Type<?> token(Type type) {
        return Types.forJavaLangReflectType((Type)type);
    }
}

