/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13D;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field25P;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field50A;
import com.prowidesoftware.swift.model.field.Field50F;
import com.prowidesoftware.swift.model.field.Field50K;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT910
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT910.class.getName());
    public static final String NAME = "910";

    public MT910(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT910(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT910 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT910(m);
    }

    public MT910() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT910(String sender, String receiver) {
        super(910, sender, receiver);
    }

    public MT910(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT910.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT910 object from FIN content with a Service Message. Check if the MT910 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT910 object from FIN content with message type " + param.getType());
        }
    }

    public static MT910 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT910(fin);
    }

    public MT910(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT910 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT910(stream);
    }

    public MT910(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT910 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT910(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT910 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT910 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT910 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT910 fromJson(String json) {
        return (MT910)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25P getField25P() {
        Tag t = this.tag("25P");
        if (t != null) {
            return new Field25P(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field13D getField13D() {
        Tag t = this.tag("13D");
        if (t != null) {
            return new Field13D(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field50A getField50A() {
        Tag t = this.tag("50A");
        if (t != null) {
            return new Field50A(t.getValue());
        }
        return null;
    }

    public Field50F getField50F() {
        Tag t = this.tag("50F");
        if (t != null) {
            return new Field50F(t.getValue());
        }
        return null;
    }

    public Field50K getField50K() {
        Tag t = this.tag("50K");
        if (t != null) {
            return new Field50K(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field56A getField56A() {
        Tag t = this.tag("56A");
        if (t != null) {
            return new Field56A(t.getValue());
        }
        return null;
    }

    public Field56D getField56D() {
        Tag t = this.tag("56D");
        if (t != null) {
            return new Field56D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

