/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionContext;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConnectionPostProcessor;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.impl.AbstractFrameHandlerFactory;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;

public class SocketFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    private final SocketFactory factory;
    private final ExecutorService shutdownExecutor;

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl) {
        this(connectionTimeout, factory, configurator, ssl, null);
    }

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl, ExecutorService shutdownExecutor) {
        this(connectionTimeout, factory, configurator, ssl, shutdownExecutor, null);
    }

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl, ExecutorService shutdownExecutor, ConnectionPostProcessor connectionPostProcessor) {
        super(connectionTimeout, configurator, ssl, connectionPostProcessor);
        this.factory = factory;
        this.shutdownExecutor = shutdownExecutor;
    }

    @Override
    public FrameHandler create(Address addr) throws IOException {
        String hostName = addr.getHost();
        int portNumber = ConnectionFactory.portOrDefault(addr.getPort(), this.ssl);
        Socket socket = null;
        try {
            socket = this.factory.createSocket();
            this.configurator.configure(socket);
            socket.connect(new InetSocketAddress(hostName, portNumber), this.connectionTimeout);
            this.connectionPostProcessor.postProcess(new ConnectionContext(socket, addr, this.ssl, null));
            return this.create(socket);
        }
        catch (IOException ioe) {
            SocketFrameHandlerFactory.quietTrySocketClose(socket);
            throw ioe;
        }
    }

    public FrameHandler create(Socket sock) throws IOException {
        return new SocketFrameHandler(sock, this.shutdownExecutor);
    }

    private static void quietTrySocketClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

