/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Visitor;
import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import java.util.Collections;
import java.util.Map;

public class SqlTypeSetterVisitor
implements Visitor<SqlTreeNode> {
    private final Map<String, SqlExpressionType> identifierType;

    public SqlTypeSetterVisitor(Map<String, SqlExpressionType> identifierType) {
        if (identifierType == null) {
            throw new IllegalArgumentException("Identifier Type map cannot be null");
        }
        this.identifierType = identifierType;
    }

    public SqlTypeSetterVisitor() {
        this(Collections.emptyMap());
    }

    public boolean visitBefore(SqlTreeNode parent, SqlTreeNode[] children) {
        return true;
    }

    public boolean visitAfter(SqlTreeNode parent, SqlTreeNode[] children) {
        parent.getExpValue().setType(this.typeOf(parent, children));
        return true;
    }

    private final SqlExpressionType typeOf(SqlTreeNode parent, SqlTreeNode[] children) {
        switch (parent.treeType()) {
            case BINARYOP: {
                switch (parent.value().type()) {
                    case CMP_EQ: 
                    case CMP_NEQ: {
                        return SqlTypeSetterVisitor.equalTypeBool(children[0].getExpValue().getType(), children[1].getExpValue().getType());
                    }
                    case CMP_GT: 
                    case CMP_GTEQ: 
                    case CMP_LT: 
                    case CMP_LTEQ: {
                        return SqlTypeSetterVisitor.arithTypeBool(children[0].getExpValue().getType(), children[1].getExpValue().getType());
                    }
                    case LIKE: 
                    case NOT_LIKE: 
                    case IN: 
                    case NOT_IN: {
                        return SqlTypeSetterVisitor.stringTypeBool(children[0].getExpValue().getType());
                    }
                    case OP_DIV: 
                    case OP_MINUS: 
                    case OP_MULT: 
                    case OP_PLUS: {
                        return SqlTypeSetterVisitor.arithTypeArith(children[0].getExpValue().getType(), children[1].getExpValue().getType());
                    }
                }
                break;
            }
            case CONJUNCTION: 
            case DISJUNCTION: {
                return SqlTypeSetterVisitor.boolTypeBool(children[0].getExpValue().getType(), children[1].getExpValue().getType());
            }
            case LEAF: {
                switch (parent.value().type()) {
                    case TRUE: 
                    case FALSE: {
                        return SqlExpressionType.BOOL;
                    }
                    case FLOAT: 
                    case HEX: 
                    case INT: {
                        return SqlExpressionType.ARITH;
                    }
                    case IDENT: {
                        return this.identifierType(parent.value().getIdent());
                    }
                    case LIST: {
                        return SqlExpressionType.LIST;
                    }
                    case STRING: {
                        return SqlExpressionType.STRING;
                    }
                }
                break;
            }
            case POSTFIXUNARYOP: {
                return SqlExpressionType.BOOL;
            }
            case PREFIXUNARYOP: {
                switch (parent.value().type()) {
                    case NOT: {
                        return SqlTypeSetterVisitor.boolTypeBool(children[0].getExpValue().getType());
                    }
                    case OP_MINUS: 
                    case OP_PLUS: {
                        return SqlTypeSetterVisitor.arithTypeArith(children[0].getExpValue().getType());
                    }
                }
                break;
            }
            case TERNARYOP: {
                return SqlTypeSetterVisitor.arithTypeBool(children[0].getExpValue().getType(), children[1].getExpValue().getType(), children[2].getExpValue().getType());
            }
            case PATTERN1: 
            case PATTERN2: {
                break;
            }
            case LIST: {
                return SqlExpressionType.LIST;
            }
            case COLLAPSE1: 
            case COLLAPSE2: 
            case JOINLIST: {
                throw new RuntimeException(String.format("Node type: [%s] should not occur", new Object[]{parent.treeType()}));
            }
        }
        return SqlExpressionType.NOT_SET;
    }

    private final SqlExpressionType identifierType(String ident) {
        if (this.identifierType.containsKey(ident)) {
            return this.identifierType.get(ident);
        }
        return SqlExpressionType.ANY;
    }

    private static SqlExpressionType arithTypeBool(SqlExpressionType expType, SqlExpressionType expType2, SqlExpressionType expType3) {
        if (SqlExpressionType.isArith(expType) && SqlExpressionType.isArith(expType2) && SqlExpressionType.isArith(expType3)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType boolTypeBool(SqlExpressionType expType, SqlExpressionType expType2) {
        if (SqlExpressionType.isBool(expType) && SqlExpressionType.isBool(expType2)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType arithTypeArith(SqlExpressionType expType) {
        if (SqlExpressionType.isArith(expType)) {
            return SqlExpressionType.ARITH;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType arithTypeArith(SqlExpressionType expType, SqlExpressionType expType2) {
        if (SqlExpressionType.isArith(expType) && SqlExpressionType.isArith(expType2)) {
            return SqlExpressionType.ARITH;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType stringTypeBool(SqlExpressionType expType) {
        if (SqlExpressionType.isString(expType)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType boolTypeBool(SqlExpressionType expType) {
        if (SqlExpressionType.isBool(expType)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType arithTypeBool(SqlExpressionType expType, SqlExpressionType expType2) {
        if (SqlExpressionType.isArith(expType) && SqlExpressionType.isArith(expType2)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }

    private static SqlExpressionType equalTypeBool(SqlExpressionType expType, SqlExpressionType expType2) {
        if (SqlExpressionType.isBool(expType) && SqlExpressionType.isBool(expType2)) {
            return SqlExpressionType.BOOL;
        }
        if (SqlExpressionType.isArith(expType) && SqlExpressionType.isArith(expType2)) {
            return SqlExpressionType.BOOL;
        }
        if (SqlExpressionType.isString(expType) && SqlExpressionType.isString(expType2)) {
            return SqlExpressionType.BOOL;
        }
        return SqlExpressionType.INVALID;
    }
}

